<%--

    Licensed to The OpenNMS Group, Inc (TOG) under one or more
    contributor license agreements.  See the LICENSE.md file
    distributed with this work for additional information
    regarding copyright ownership.

    TOG licenses this file to You under the GNU Affero General
    Public License Version 3 (the "License") or (at your option)
    any later version.  You may not use this file except in
    compliance with the License.  You may obtain a copy of the
    License at:

         https://www.gnu.org/licenses/agpl-3.0.txt

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
    either express or implied.  See the License for the specific
    language governing permissions and limitations under the
    License.

--%>
<%@page language="java"
  contentType="text/html"
  session="true"
  import="
    org.opennms.web.controller.ksc.FormProcReportController
"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<% final String baseHref = org.opennms.web.api.Util.calculateUrlBase( request ); %>

<%@ page import="org.opennms.web.utils.Bootstrap" %>
<% Bootstrap.with(pageContext)
          .headTitle("Performance")
          .headTitle("Reports")
          .headTitle("KSC")
          .breadcrumb("Reports", "report/index.jsp")
          .breadcrumb("KSC Reports", "KSC/index.jsp")
          .breadcrumb("Custom Report")
          .flags("renderGraphs")
          .build(request);
%>
<jsp:directive.include file="/includes/bootstrap.jsp" />

<%-- A script to Save the file --%>
<script type="text/javascript">
  function saveReport()
  {
    document.customize_form.action.value = "<c:out value="<%=FormProcReportController.Actions.Save.toString()%>"/>"; 
    document.customize_form.submit();
  }

  function addNewGraph()
  {
    document.customize_form.action.value = "<c:out value="<%=FormProcReportController.Actions.AddGraph.toString()%>"/>"; 
    document.customize_form.submit();
  }

  function modifyGraph(graph_index)
  {
    document.customize_form.action.value = "<c:out value="<%=FormProcReportController.Actions.ModGraph.toString()%>"/>"; 
    document.customize_form.graph_index.value = graph_index; 
    document.customize_form.submit();
  }

  function deleteGraph(graph_index)
  {
    document.customize_form.action.value = "<c:out value="<%=FormProcReportController.Actions.DelGraph.toString()%>"/>";
    document.customize_form.graph_index.value = graph_index; 
    document.customize_form.submit();
  }

  function cancelReport()
  {
    if (confirm("Do you really want to cancel configuration changes?")) {
        setLocation("KSC/index.jsp");
    }
  }
</script>

<div class="card">
  <div class="card-header">
    <span>Customized Report Configuration</span>
  </div>
  <div class="card-body">
    <form class="" name="customize_form" method="get" action="<%= baseHref %>KSC/formProcReport.htm">
      <input type="hidden" name="<%=FormProcReportController.Parameters.action%>" value="none"/>
      <input type="hidden" name="<%=FormProcReportController.Parameters.graph_index%>" value="-1"/>
      <div class="form-group">
        <label class="label-control">Title</label>
        <input class="form-control" type="text" name="<%=FormProcReportController.Parameters.report_title%>" value="${title}" size="80" maxlength="80"/>
      </div>
      <table class="table table-sm">
        <c:if test="${fn:length(resultSets) > 0}">
          <c:forEach var="graphNum" begin="0" end="${fn:length(resultSets) - 1}">
            <c:set var="resultSet" value="${resultSets[graphNum]}"/>
            <tr>
              <td align="right" class="w-25">
                <div class="btn-toolbar" role="toolbar">
                  <div class="btn-group" role="group">
                    <button class="btn btn-secondary" onclick="modifyGraph(${graphNum})">Modify</button>
                    <button class="btn btn-secondary" onclick="deleteGraph(${graphNum})">Delete</button>
                  </div>
                </div>
                <div>
                  ${resultSet.title}
                  <br/>
                  <c:if test="${!empty resultSet.resource.parent}">
                    ${resultSet.resource.parent.resourceType.label}:
                    <c:choose>
                      <c:when test="${!empty resultSet.resource.parent.link}">
                        <a href="<c:url value='${resultSet.resource.parent.link}'/>">${resultSet.resource.parent.label}</a>
                      </c:when>
                      <c:otherwise>
                        ${resultSet.resource.parent.label}
                      </c:otherwise>
                    </c:choose>
                    <br />
                  </c:if>
                  ${resultSet.resource.resourceType.label}:
                  <c:choose>
                    <c:when test="${!empty resultSet.resource.link}">
                      <a href="<c:url value='${resultSet.resource.link}'/>">${resultSet.resource.label}</a>
                    </c:when>
                    <c:otherwise>
                      ${resultSet.resource.label}
                    </c:otherwise>
                  </c:choose>
                  <br/>
                  <br/>
                  From: ${resultSet.start}
                  <br/>
                  To: ${resultSet.end}
                </div>
              </td>
              <td align="left" class="w-75">
                <div class="graph-container" data-graph-zoomable="false" data-resource-id="${resultSet.resource.id}" data-graph-name="${resultSet.prefabGraph.name}" data-graph-title="${resultSet.prefabGraph.title}" data-graph-start="${resultSet.start.time}" data-graph-end="${resultSet.end.time}"></div>
              </td>
            </tr>
          </c:forEach>
        </c:if>
        <tr>
          <td colspan="3">
            <div class="form-group col-md-12">
              <c:choose>
                <c:when test="${showTimeSpan}">
                  <c:set var="checked" value="checked"/>
                </c:when>
                <c:otherwise>
                  <c:set var="checked" value=""/>
                </c:otherwise>
               </c:choose>
              <label>
                <input type="checkbox" name="<%=FormProcReportController.Parameters.show_timespan%>" ${checked} />
                Show Timespan Button (allows global manipulation of report timespan)
              </label>
            </div>
            <div class="form-group col-md-12">
              <c:choose>
                <c:when test="${showGraphType}">
                  <c:set var="checked" value="checked"/>
                </c:when>
                <c:otherwise>
                  <c:set var="checked" value=""/>
                </c:otherwise>
              </c:choose>
              <label>
                <input type="checkbox" name="<%=FormProcReportController.Parameters.show_graphtype%>" ${checked} />
                Show Graphtype Button (allows global manipulation of report prefabricated graph type)
              </label>
            </div>
            <div class="form-group">
              <div class="col-md-2">
              <label>Number of graphs to show per line in the report.</label>
              <select class="form-control custom-select" name="<%=FormProcReportController.Parameters.graphs_per_line%>">
                <c:choose>
                  <c:when test="${graphsPerLine == 0}">
                    <option selected value="0">default</option>
                  </c:when>
                  <c:otherwise>
                    <option value="0">default</option>
                  </c:otherwise>
                </c:choose>
                <c:choose>
                  <c:when test="${graphsPerLine == 1}">
                    <option selected value="1">1</option>
                  </c:when>
                  <c:otherwise>
                    <option value="1">1</option>
                  </c:otherwise>
                </c:choose>
                <c:choose>
                  <c:when test="${graphsPerLine == 2}">
                    <option selected value="2">2</option>
                  </c:when>
                  <c:otherwise>
                    <option value="2">2</option>
                  </c:otherwise>
                </c:choose>
                <c:choose>
                  <c:when test="${graphsPerLine == 3}">
                    <option selected value="3">3</option>
                  </c:when>
                  <c:otherwise>
                    <option value="3">3</option>
                  </c:otherwise>
                </c:choose>
                <c:choose>
                  <c:when test="${graphsPerLine == 4}">
                    <option selected value="4">4</option>
                  </c:when>
                  <c:otherwise>
                    <option value="4">4</option>
                  </c:otherwise>
                </c:choose>
                <c:choose>
                  <c:when test="${graphsPerLine == 5}">
                    <option selected value="5">5</option>
                  </c:when>
                  <c:otherwise>
                    <option value="5">5</option>
                  </c:otherwise>
                </c:choose>
                <c:choose>
                  <c:when test="${graphsPerLine == 6}">
                    <option selected value="6">6</option>
                  </c:when>
                  <c:otherwise>
                    <option value="6">6</option>
                  </c:otherwise>
                </c:choose>
              </select>
              </div>
            </div>
            <div class="btn-group">
              <button type="button" class="btn btn-secondary" onclick="addNewGraph()" alt="Add a new graph to the report">Add New Graph</button>
              <button type="button" class="btn btn-secondary" onclick="saveReport()" alt="Save the Report to File">Save Report</button>
              <button type="button" class="btn btn-secondary" onclick="cancelReport()" alt="Cancel the report configuration">Cancel</button>
            </div>
          </td>
        </tr>
        <tr>
          <td colspan="3">
            If you make any changes, please make sure to save the report
            when you are done.  Changes will only be saved by using the
            "Save" button on this page.
          </td>
        </tr>
      </table>
    </form>
  </div>
</div>

<jsp:include page="/includes/bootstrap-footer.jsp" flush="false"/>
