/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.plugins.elasticsearch.rest;

import java.util.List;

import org.opennms.features.jest.client.ConnectionPoolShutdownException;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExceptionUtils {

    private ExceptionUtils() {}

    public static void handle(Class context, ConnectionPoolShutdownException ex, List<Event> events) {
        final Logger LOG = LoggerFactory.getLogger(context);
        LOG.error("Connection pool was shut down. Cannot recover.", ex);
        LOG.debug("The following events are not forwarded: {}", events);
    }
}