/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.osgi;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.MessageConsumerManager;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.common.AbstractMessageConsumerManager;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.core.soa.lookup.ServiceRegistryLookup;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class OsgiIpcManager
extends AbstractMessageConsumerManager
implements RpcClientFactory,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiIpcManager.class);
    private final ThreadFactory sinkRegisterConsumerThreadFactory = new ThreadFactoryBuilder().setNameFormat("sink-register-consumer-delegate-%d").build();
    private final ExecutorService sinkRegisterConsumerExecutor = Executors.newCachedThreadPool(this.sinkRegisterConsumerThreadFactory);
    private final ServiceLookup<Class<?>, String> blockingServiceLookup = new ServiceLookupBuilder((ServiceLookup)new ServiceRegistryLookup((ServiceRegistry)DefaultServiceRegistry.INSTANCE)).blocking().build();
    private MessageConsumerManager consumerManagerDelegate;

    public <R extends RpcRequest, S extends RpcResponse> RpcClient<R, S> getClient(RpcModule<R, S> module) {
        return new RpcClientDelegate<R, S>(module);
    }

    private RpcClientFactory getRpcClientFactory() {
        return (RpcClientFactory)this.blockingServiceLookup.lookup(RpcClientFactory.class, (Object)"(!(strategy=delegate))");
    }

    private MessageConsumerManager getConsumerManager() {
        this.consumerManagerDelegate = (MessageConsumerManager)this.blockingServiceLookup.lookup(MessageConsumerManager.class, (Object)"(!(strategy=delegate))");
        return this.consumerManagerDelegate;
    }

    private <R extends RpcRequest, S extends RpcResponse> RpcClient getRpcClient(RpcModule<R, S> module) {
        RpcClientFactory clientFactory = this.getRpcClientFactory();
        if (clientFactory != null) {
            return clientFactory.getClient(module);
        }
        return null;
    }

    public <S extends Message, T extends Message> void dispatch(SinkModule<S, T> module, T message) {
        MessageConsumerManager consumerManagerDelegate = this.getConsumerManager();
        if (consumerManagerDelegate != null) {
            consumerManagerDelegate.dispatch(module, message);
        }
    }

    protected void startConsumingForModule(SinkModule<?, Message> module) throws Exception {
    }

    protected void stopConsumingForModule(SinkModule<?, Message> module) throws Exception {
    }

    public <S extends Message, T extends Message> void registerConsumer(MessageConsumer<S, T> consumer) throws Exception {
        this.sinkRegisterConsumerExecutor.execute(() -> this.loadManagerAndRegisterConsumer(consumer));
    }

    private <S extends Message, T extends Message> void loadManagerAndRegisterConsumer(MessageConsumer<S, T> consumer) {
        MessageConsumerManager consumerManagerDelegate = this.getConsumerManager();
        if (consumerManagerDelegate != null) {
            try {
                consumerManagerDelegate.registerConsumer(consumer);
            }
            catch (Exception e) {
                LOG.error("Exception while registering consumer for module {}", (Object)consumer.getModule(), (Object)e);
            }
        }
    }

    public <S extends Message, T extends Message> void unregisterConsumer(MessageConsumer<S, T> consumer) throws Exception {
        if (this.consumerManagerDelegate != null) {
            this.consumerManagerDelegate.unregisterConsumer(consumer);
        }
    }

    public void destroy() throws Exception {
        this.sinkRegisterConsumerExecutor.shutdownNow();
    }

    private class RpcClientDelegate<R extends RpcRequest, S extends RpcResponse>
    implements RpcClient {
        private RpcModule<R, S> module;
        private RpcClient delegate;

        private RpcClientDelegate(RpcModule<R, S> module) {
            this.module = module;
        }

        public CompletableFuture execute(RpcRequest request) {
            if (this.delegate == null) {
                this.delegate = OsgiIpcManager.this.getRpcClient(this.module);
            }
            if (this.delegate != null) {
                return this.delegate.execute(request);
            }
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new RuntimeException("No RPC client found"));
            return future;
        }
    }
}

