/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.labels;

import io.pyroscope.labels.Ref;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

class RefCounted<T> {
    public static final RefCounted<String> strings = new RefCounted<String>(String2 -> {});
    public static final RefCounted<Map<Ref<String>, Ref<String>>> contexts = new RefCounted<Map>(context -> {
        for (Map.Entry it : context.entrySet()) {
            ((Ref)it.getKey()).refCount.decrementAndGet();
            ((Ref)it.getValue()).refCount.decrementAndGet();
        }
    });
    public final ReleasedCallback<T> releasedCallback;
    public final ConcurrentHashMap<T, Ref<T>> valueToRef = new ConcurrentHashMap();
    public final AtomicLong idCounter = new AtomicLong(0L);

    RefCounted(ReleasedCallback<T> releasedCallback) {
        this.releasedCallback = releasedCallback;
    }

    Ref<T> acquireRef(T v) {
        boolean[] fresh = new boolean[1];
        return this.acquireRef(v, fresh);
    }

    Ref<T> acquireRef(T v, boolean[] outFresh) {
        Ref res;
        outFresh[0] = false;
        block0: while (true) {
            long counter;
            boolean success;
            res = this.valueToRef.computeIfAbsent(v, t -> {
                Ref<Object> ref = new Ref<Object>(t, this.idCounter.incrementAndGet());
                outFresh[0] = true;
                return ref;
            });
            if (outFresh[0]) {
                return res;
            }
            do {
                if ((counter = res.refCount.get()) < 0L) continue block0;
            } while (!(success = res.refCount.compareAndSet(counter, counter + 1L)));
            break;
        }
        return res;
    }

    void gc() {
        Iterator<Ref<T>> it = this.valueToRef.values().iterator();
        while (it.hasNext()) {
            boolean success;
            Ref<T> ref = it.next();
            if (ref.refCount.get() != 0L || !(success = ref.refCount.compareAndSet(0L, -1L))) continue;
            it.remove();
            this.releasedCallback.released(ref.val);
        }
    }

    void resetForTesting() {
        this.idCounter.set(0L);
    }

    static interface ReleasedCallback<T> {
        public void released(T var1);
    }
}

