/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import org.opennms.netmgt.snmp.AbstractSnmpValue;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpOctetString
implements SnmpSyntax,
Cloneable,
Serializable {
    static final long serialVersionUID = 1848780739976444105L;
    private byte[] m_data = null;
    public static final byte ASNTYPE = 4;

    protected void assumeString(byte[] data) {
        this.m_data = data == null ? data : (byte[])data.clone();
    }

    public SnmpOctetString() {
    }

    public SnmpOctetString(byte[] data) {
        this();
        if (data != null) {
            this.m_data = new byte[data.length];
            System.arraycopy(data, 0, this.m_data, 0, data.length);
        }
    }

    public SnmpOctetString(SnmpOctetString second) {
        this(second.m_data);
    }

    public byte[] getString() {
        return this.m_data;
    }

    public void setString(byte[] data) {
        this.m_data = null;
        if (data != null) {
            this.m_data = new byte[data.length];
            System.arraycopy(data, 0, this.m_data, 0, data.length);
        }
    }

    public void setString(String data) {
        this.m_data = null;
        if (data != null) {
            this.m_data = data.getBytes();
        }
    }

    public int getLength() {
        int len = 0;
        if (this.m_data != null) {
            len = this.m_data.length;
        }
        return len;
    }

    @Override
    public byte typeId() {
        return 4;
    }

    @Override
    public int encodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnEncodingException {
        if (this.m_data == null) {
            throw new AsnEncodingException("No data in octet string");
        }
        return encoder.buildString(buf, offset, this.typeId(), this.m_data);
    }

    @Override
    public int decodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnDecodingException {
        Object[] rVals = encoder.parseString(buf, offset);
        if (((Byte)rVals[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        this.m_data = (byte[])rVals[2];
        return (Integer)rVals[0];
    }

    @Override
    public SnmpSyntax duplicate() {
        return new SnmpOctetString(this);
    }

    public Object clone() {
        return new SnmpOctetString(this);
    }

    public String toString() {
        boolean asHex = false;
        for (int i = 0; i < this.m_data.length; ++i) {
            byte b = this.m_data[i];
            if ((b >= 32 || b == 10 || b == 13) && b != 127) continue;
            asHex = true;
            break;
        }
        String rs = null;
        if (asHex) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.m_data.length; ++i) {
                int x = this.m_data[i] & 0xFF;
                if (x < 16) {
                    b.append('0');
                }
                b.append(Integer.toString(x, 16).toUpperCase());
                if (i >= this.m_data.length - 1) continue;
                b.append(' ');
            }
            rs = b.toString();
        } else {
            rs = new String(this.m_data);
        }
        return rs;
    }

    public static String toDisplayString(SnmpOctetString octetString) {
        if (octetString == null) {
            return null;
        }
        byte[] bytes = octetString.getString();
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (bytes.length == 1 && bytes[0] == 0) {
            return null;
        }
        byte[] newBytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            newBytes[i] = AbstractSnmpValue.getAdditionalPrintableCharacters().getOrDefault(bytes[i], Character.isISOControl((char)bytes[i]) ? (byte)46 : bytes[i]);
        }
        return new String(newBytes);
    }

    public static String toHexString(SnmpOctetString ostr) {
        if (ostr == null) {
            return null;
        }
        StringBuilder sbuf = new StringBuilder();
        if (ostr.getLength() > 0) {
            byte[] bytes = ostr.getString();
            for (int i = 0; i < bytes.length; ++i) {
                sbuf.append(Integer.toHexString(bytes[i] >> 4 & 0xF));
                sbuf.append(Integer.toHexString(bytes[i] & 0xF));
            }
        }
        return sbuf.toString().trim();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SnmpOctetString) {
            SnmpOctetString str = (SnmpOctetString)obj;
            if (this.m_data == null) {
                return str.m_data == null;
            }
            if (this.m_data.length != str.m_data.length) {
                return false;
            }
            for (int i = 0; i < this.m_data.length; ++i) {
                if (this.m_data[i] == str.m_data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

