/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import java.math.BigInteger;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpCounter64
implements SnmpSyntax,
Cloneable,
Serializable {
    static final long serialVersionUID = -192572343143669856L;
    private BigInteger m_value;
    public static final byte ASNTYPE = 70;

    public SnmpCounter64() {
        this.m_value = BigInteger.valueOf(0L);
        this.m_value.clearBit(65);
    }

    public SnmpCounter64(long value) {
        this.m_value = BigInteger.valueOf(value & Long.MAX_VALUE);
        this.m_value.clearBit(65);
    }

    public SnmpCounter64(BigInteger value) {
        this.m_value = new BigInteger(value.toByteArray());
        this.m_value.clearBit(65);
    }

    public SnmpCounter64(SnmpCounter64 second) {
        this.m_value = new BigInteger(second.m_value.toByteArray());
        this.m_value.clearBit(65);
    }

    public SnmpCounter64(String value) {
        if (value == null) {
            throw new NullPointerException("The constructor argument must not be null");
        }
        this.m_value = new BigInteger(value);
        if (this.m_value.signum() < 0) {
            throw new IllegalArgumentException("The decoded value may not be negative");
        }
    }

    public BigInteger getValue() {
        return this.m_value;
    }

    public void setValue(BigInteger value) {
        this.m_value = new BigInteger(value.toByteArray());
        this.m_value.clearBit(65);
    }

    @Override
    public byte typeId() {
        return 70;
    }

    @Override
    public int encodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnEncodingException {
        return encoder.buildUInteger64(buf, offset, this.typeId(), this.getValue());
    }

    @Override
    public int decodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnDecodingException {
        Object[] rVals = encoder.parseUInteger64(buf, offset);
        if (((Byte)rVals[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        this.setValue((BigInteger)rVals[2]);
        return (Integer)rVals[0];
    }

    @Override
    public SnmpSyntax duplicate() {
        return new SnmpCounter64(this);
    }

    public Object clone() {
        return new SnmpCounter64(this);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

