/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;

public enum AsPathSegmentType {
    AS_SET(1),
    AS_SEQUENCE(2);

    public final int value;

    private AsPathSegmentType(int value) {
        this.value = value;
    }

    public static AsPathSegmentType from(ByteBuf buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuf)buffer);
        switch (value) {
            case 1: {
                return AS_SET;
            }
            case 2: {
                return AS_SEQUENCE;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeInt32("value", this.value);
    }
}

