/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.dhcpd.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;
import org.dhcp4java.DHCPPacket;
import org.opennms.features.dhcpd.impl.DhcpdImpl;
import org.opennms.features.dhcpd.impl.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Listener
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Listener.class);
    private boolean shutdown = false;
    private final int port;
    private final DhcpdImpl dhcpd;
    private DatagramSocket datagramSocket;
    private Thread thread;

    public Listener(DhcpdImpl dhcpd, int port) {
        this.dhcpd = dhcpd;
        this.port = port;
    }

    public void send(DatagramPacket message) throws IOException {
        this.datagramSocket.send(message);
    }

    public synchronized boolean start() {
        if (this.shutdown) {
            return false;
        }
        if (this.thread != null && this.thread.isAlive()) {
            return true;
        }
        try {
            this.datagramSocket = new DatagramSocket(this.port);
            this.datagramSocket.setBroadcast(true);
            this.datagramSocket.setSoTimeout(1000);
        }
        catch (Exception e) {
            LOG.error("Error opening datagram socket for port {}, DHCP Monitor will not work", (Object)this.port);
            return false;
        }
        this.thread = new Thread(this);
        this.thread.start();
        return true;
    }

    public synchronized void stop() {
        this.shutdown = true;
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }

    @Override
    public void run() {
        byte[] dgbuf = new byte[2048];
        while (!this.shutdown) {
            try {
                DatagramPacket pkt = new DatagramPacket(dgbuf, dgbuf.length);
                this.datagramSocket.receive(pkt);
                Response response = new Response(pkt.getAddress(), DHCPPacket.getPacket((DatagramPacket)pkt));
                LOG.debug("Received DHCP response on port {}, xid {}, type {}, address {}", new Object[]{this.port, response.getDhcpPacket().getXid(), response.getDhcpPacket().getDHCPMessageType(), response.getDhcpPacket().getAddress()});
                this.dhcpd.checkTransactions(response);
            }
            catch (SocketTimeoutException pkt) {
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.warn("An error occurred when reading DHCP response", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn("Failed to read message, I/O error", (Throwable)e);
            }
            catch (Throwable t) {
                LOG.warn("Undeclared throwable caught", t);
            }
        }
    }
}

