/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.sampleread;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.integration.api.v1.timeseries.Aggregation;
import org.opennms.integration.api.v1.timeseries.DataPoint;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.TimeSeriesData;
import org.opennms.integration.api.v1.timeseries.TimeSeriesFetchRequest;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableMetric;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTimeSeriesFetchRequest;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.model.QueryMetadata;
import org.opennms.netmgt.measurements.model.QueryNode;
import org.opennms.netmgt.measurements.model.QueryResource;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.measurements.utils.Utils;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.timeseries.TimeseriesStorageManager;
import org.opennms.netmgt.timeseries.sampleread.LateAggregationParams;
import org.opennms.netmgt.timeseries.sampleread.aggregation.NewtsConverterUtils;
import org.opennms.netmgt.timeseries.sampleread.aggregation.NewtsLikeSampleAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.ObjectRetrievalFailureException;

public class TimeseriesFetchStrategy
implements MeasurementFetchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TimeseriesFetchStrategy.class);
    public static final int PARALLELISM = SystemProperties.getInteger((String)"org.opennms.timeseries.query.parallelism", (int)Runtime.getRuntime().availableProcessors());
    private ResourceDao resourceDao;
    private final ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("TimeseriesFetchStrategy-%d").build();
    private final ExecutorService threadPool = Executors.newCachedThreadPool(this.namedThreadFactory);
    private final Semaphore availableAggregationThreads = new Semaphore(PARALLELISM);
    private TimeseriesStorageManager storageManager;
    private Timer sampleReadTsTimer;
    private Timer sampleReadIntegrationTimer;

    /*
     * WARNING - void declaration
     */
    public FetchResults fetch(long start, long end, long step, int maxrows, Long interval, Long heartbeat, List<Source> sources, boolean relaxed) {
        try (Timer.Context context = this.sampleReadIntegrationTimer.time();){
            void var21_25;
            LateAggregationParams lag = LateAggregationParams.builder().step(step).interval(interval).heartbeat(heartbeat).build();
            Instant startTs = Instant.ofEpochMilli(start);
            Instant endTs = Instant.ofEpochMilli(end);
            HashMap constants = Maps.newHashMap();
            ArrayList<QueryResource> resources = new ArrayList<QueryResource>();
            Map<OnmsResource, List<Source>> sourcesByResource = this.loadOnmsResources(sources, relaxed);
            if (sourcesByResource == null) {
                FetchResults fetchResults = null;
                return fetchResults;
            }
            HashMap sourcesByNewtsResourceId = Maps.newHashMap();
            for (Map.Entry<OnmsResource, List<Source>> entry : sourcesByResource.entrySet()) {
                OnmsResource onmsResource = entry.getKey();
                for (Source source : entry.getValue()) {
                    Utils.convertStringAttributesToConstants((String)source.getLabel(), (Map)onmsResource.getStringPropertyAttributes(), (Map)constants);
                    resources.add(this.getResourceInfo(onmsResource, source));
                    RrdGraphAttribute rrdGraphAttribute = (RrdGraphAttribute)onmsResource.getRrdGraphAttributes().get(source.getAttribute());
                    if (rrdGraphAttribute == null && !Strings.isNullOrEmpty((String)source.getFallbackAttribute())) {
                        LOG.error("No attribute with name '{}', using fallback-attribute with name '{}'", (Object)source.getAttribute(), (Object)source.getFallbackAttribute());
                        source.setAttribute(source.getFallbackAttribute());
                        source.setFallbackAttribute(null);
                        rrdGraphAttribute = (RrdGraphAttribute)onmsResource.getRrdGraphAttributes().get(source.getAttribute());
                    }
                    if (rrdGraphAttribute == null) {
                        if (relaxed) continue;
                        LOG.error("No attribute with name: {}", (Object)source.getAttribute());
                        Iterator<Map.Entry<Source, List<DataPoint>>> iterator = null;
                        return iterator;
                    }
                    String newtsResourceId = rrdGraphAttribute.getRrdRelativePath();
                    if (newtsResourceId.startsWith(File.separator)) {
                        newtsResourceId = newtsResourceId.substring(File.separator.length(), newtsResourceId.length());
                    }
                    List listOfSources = sourcesByNewtsResourceId.computeIfAbsent(newtsResourceId, k -> Lists.newLinkedList());
                    listOfSources.add(source);
                }
            }
            HashMap measurementsByNewtsResourceId = Maps.newHashMapWithExpectedSize((int)sourcesByNewtsResourceId.size());
            for (Map.Entry entry : sourcesByNewtsResourceId.entrySet()) {
                measurementsByNewtsResourceId.put((String)entry.getKey(), this.threadPool.submit(() -> this.getMeasurementsForResourceCallable((String)entry.getKey(), (List)entry.getValue(), startTs, endTs, lag)));
            }
            if (measurementsByNewtsResourceId.entrySet().isEmpty()) {
                long[] lArray = new long[]{};
            } else {
                long[] lArray = this.toSampleList(measurementsByNewtsResourceId.entrySet().iterator().next()).values().iterator().next().stream().map(DataPoint::getTime).mapToLong(Instant::toEpochMilli).toArray();
            }
            HashMap hashMap = Maps.newHashMap();
            for (Map.Entry entry : measurementsByNewtsResourceId.entrySet()) {
                Map<Source, List<DataPoint>> sampleList = this.toSampleList(entry);
                for (Map.Entry<Source, List<DataPoint>> column : sampleList.entrySet()) {
                    double[] values = column.getValue().stream().mapToDouble(DataPoint::getValue).toArray();
                    hashMap.put(column.getKey().getLabel(), values);
                }
            }
            FetchResults fetchResults = new FetchResults((long[])var21_25, (Map)hashMap, lag.getStep(), (Map)constants, new QueryMetadata(resources));
            if (relaxed) {
                Utils.fillMissingValues((FetchResults)fetchResults, sources);
            }
            LOG.trace("Fetch results: {}", (Object)fetchResults);
            FetchResults fetchResults2 = fetchResults;
            return fetchResults2;
        }
    }

    private Map<Source, List<DataPoint>> toSampleList(Map.Entry<String, Future<Map<Source, List<DataPoint>>>> entry) {
        try {
            return entry.getValue().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Map<OnmsResource, List<Source>> loadOnmsResources(List<Source> sources, boolean relaxed) {
        Map<ResourceId, List<Source>> sourcesByResourceId = sources.stream().collect(Collectors.groupingBy(source -> ResourceId.fromString((String)source.getResourceId())));
        HashMap resourceFuturesById = Maps.newHashMapWithExpectedSize((int)sourcesByResourceId.size());
        for (ResourceId resourceId : sourcesByResourceId.keySet()) {
            resourceFuturesById.put(resourceId, this.threadPool.submit(this.getResourceByIdCallable(resourceId)));
        }
        HashMap sourcesByResource = Maps.newHashMapWithExpectedSize((int)sourcesByResourceId.size());
        for (Map.Entry entry : resourceFuturesById.entrySet()) {
            try {
                OnmsResource resource = (OnmsResource)((Future)entry.getValue()).get();
                if (resource == null) {
                    if (relaxed) continue;
                    LOG.error("No resource with id: {}", entry.getKey());
                    return null;
                }
                sourcesByResource.put(resource, sourcesByResourceId.get(entry.getKey()));
            }
            catch (InterruptedException | ExecutionException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return sourcesByResource;
    }

    private Map<Source, List<DataPoint>> getMeasurementsForResourceCallable(String resourceId, List<Source> listOfSources, Instant start, Instant end, LateAggregationParams lag) throws StorageException {
        HashMap<Source, List<DataPoint>> allDataPoints = new HashMap<Source, List<DataPoint>>(listOfSources.size());
        for (Source source : listOfSources) {
            TimeSeriesData timeSeriesData;
            String metricName = source.getDataSource() != null ? source.getDataSource() : source.getAttribute();
            Aggregation aggregation = TimeseriesFetchStrategy.toAggregation(source.getAggregation());
            boolean shouldAggregateNatively = this.storageManager.get().supportsAggregation(aggregation);
            ImmutableMetric metric = ImmutableMetric.builder().intrinsicTag("resourceId", resourceId).intrinsicTag("name", metricName).build();
            Aggregation aggregationToUse = shouldAggregateNatively ? aggregation : Aggregation.NONE;
            ImmutableTimeSeriesFetchRequest request = ImmutableTimeSeriesFetchRequest.builder().metric((Metric)metric).start(start).end(end).step(Duration.ofMillis(lag.getStep())).aggregation(aggregationToUse).build();
            try (Timer.Context context = this.sampleReadTsTimer.time();){
                LOG.debug("Querying TimeseriesStorage for resource id {} with request: {}", (Object)resourceId, (Object)request);
                timeSeriesData = this.storageManager.get().getTimeSeriesData((TimeSeriesFetchRequest)request);
            }
            if (!shouldAggregateNatively) {
                List<Source> currentSources = Collections.singletonList(source);
                timeSeriesData = NewtsLikeSampleAggregator.builder().resource(resourceId).start(start).end(end).metric((Metric)metric).currentSources(currentSources).lag(lag).build().process(NewtsConverterUtils.samplesToNewtsRowIterator(timeSeriesData));
            }
            allDataPoints.put(source, timeSeriesData.getDataPoints());
        }
        return allDataPoints;
    }

    private static Aggregation toAggregation(String fn) {
        if ("average".equalsIgnoreCase(fn) || "avg".equalsIgnoreCase(fn)) {
            return Aggregation.AVERAGE;
        }
        if ("max".equalsIgnoreCase(fn)) {
            return Aggregation.MAX;
        }
        if ("min".equalsIgnoreCase(fn)) {
            return Aggregation.MIN;
        }
        throw new IllegalArgumentException("Unsupported aggregation function: " + fn);
    }

    private Callable<OnmsResource> getResourceByIdCallable(final ResourceId resourceId) {
        return new Callable<OnmsResource>(){

            @Override
            public OnmsResource call() throws IllegalArgumentException {
                OnmsResource resource = TimeseriesFetchStrategy.this.resourceDao.getResourceById(resourceId);
                if (resource != null) {
                    resource.getAttributes();
                }
                return resource;
            }
        };
    }

    @Inject
    protected void setResourceDao(ResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    @Inject
    protected void setTimeseriesStorageManager(TimeseriesStorageManager timeseriesStorage) {
        this.storageManager = timeseriesStorage;
    }

    @Inject
    protected void setMetricRegistry(@Named(value="timeseriesMetricRegistry") MetricRegistry registry) {
        this.sampleReadTsTimer = registry.timer("samples.read.ts");
        this.sampleReadIntegrationTimer = registry.timer("samples.read.integration");
    }

    private OnmsNode getNode(OnmsResource resource, Source source) {
        OnmsNode node = null;
        try {
            node = ResourceTypeUtils.getNodeFromResourceRoot((OnmsResource)resource);
        }
        catch (ObjectRetrievalFailureException objectRetrievalFailureException) {
            // empty catch block
        }
        if (node == null) {
            OnmsResource otherResource = this.resourceDao.getResourceById(ResourceId.fromString((String)source.getResourceId()).getParent());
            node = ResourceTypeUtils.getNodeFromResource((OnmsResource)otherResource);
        }
        return node;
    }

    private QueryResource getResourceInfo(OnmsResource resource, Source source) {
        if (resource == null) {
            return null;
        }
        OnmsNode node = this.getNode(resource, source);
        return new QueryResource(resource.getId().toString(), resource.getParent() == null ? null : resource.getParent().getId().toString(), resource.getLabel(), resource.getName(), node == null ? null : new QueryNode(node.getId(), node.getForeignSource(), node.getForeignId(), node.getLabel()));
    }
}

