/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dhcp4java.DHCPServerInitException;
import org.dhcp4java.DHCPServlet;
import org.dhcp4java.DHCPServletDispatcher;
import org.dhcp4java.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHCPCoreServer
implements Runnable {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DHCPCoreServer.class);
    private static final int BOUNDED_QUEUE_SIZE = 20;
    protected static final int PACKET_SIZE = 1500;
    protected DHCPServlet m_aServlet;
    protected ThreadPoolExecutor m_aThreadPool;
    protected Properties m_aProperties;
    protected Properties m_aUserProps;
    private InetSocketAddress m_aSockAddress;
    private DatagramSocket m_aServerSocket;
    private boolean m_bStopped = false;
    private static final Properties DEF_PROPS = new Properties();
    public static final String SERVER_ADDRESS = "serverAddress";
    private static final String SERVER_ADDRESS_DEFAULT = "127.0.0.1:67";
    public static final String SERVER_THREADS = "serverThreads";
    private static final String SERVER_THREADS_DEFAULT = "2";
    public static final String SERVER_THREADS_MAX = "serverThreadsMax";
    private static final String SERVER_THREADS_MAX_DEFAULT = "4";
    public static final String SERVER_THREADS_KEEPALIVE = "serverThreadsKeepalive";
    private static final String SERVER_THREADS_KEEPALIVE_DEFAULT = "10000";

    private DHCPCoreServer(DHCPServlet dHCPServlet, Properties properties) {
        this.m_aServlet = dHCPServlet;
        this.m_aUserProps = properties;
    }

    public static DHCPCoreServer initServer(DHCPServlet dHCPServlet, Properties properties) throws DHCPServerInitException {
        if (dHCPServlet == null) {
            throw new IllegalArgumentException("servlet must not be null");
        }
        DHCPCoreServer dHCPCoreServer = new DHCPCoreServer(dHCPServlet, properties);
        dHCPCoreServer.init();
        return dHCPCoreServer;
    }

    protected void init() throws DHCPServerInitException {
        if (this.m_aServerSocket != null) {
            throw new IllegalStateException("Server already initialized");
        }
        try {
            this.m_aProperties = new Properties(DEF_PROPS);
            InputStream inputStream = this.getClass().getResourceAsStream("/DHCPd.properties");
            if (inputStream != null) {
                this.m_aProperties.load(inputStream);
            } else {
                s_aLogger.error("Could not load /DHCPd.properties");
            }
            if (this.m_aUserProps != null) {
                this.m_aProperties.putAll((Map<?, ?>)this.m_aUserProps);
            }
            this.m_aSockAddress = this.getInetSocketAddress(this.m_aProperties);
            if (this.m_aSockAddress == null) {
                throw new DHCPServerInitException("Cannot find which SockAddress to open");
            }
            s_aLogger.info("Listing at " + this.m_aSockAddress.getHostString() + ":" + this.m_aSockAddress.getPort());
            this.m_aServerSocket = new DatagramSocket(null);
            this.m_aServerSocket.setBroadcast(true);
            this.m_aServerSocket.bind(this.m_aSockAddress);
            int n = Integer.parseInt(this.m_aProperties.getProperty(SERVER_THREADS));
            int n2 = Integer.parseInt(this.m_aProperties.getProperty(SERVER_THREADS_MAX));
            int n3 = Integer.parseInt(this.m_aProperties.getProperty(SERVER_THREADS_KEEPALIVE));
            this.m_aThreadPool = new ThreadPoolExecutor(n, n2, (long)n3, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(20), new ServerThreadFactory());
            this.m_aThreadPool.prestartAllCoreThreads();
            this.m_aServlet.setServer(this);
            this.m_aServlet.init(this.m_aProperties);
        }
        catch (DHCPServerInitException dHCPServerInitException) {
            throw dHCPServerInitException;
        }
        catch (Exception exception) {
            this.m_aServerSocket = null;
            s_aLogger.error("Cannot open socket", (Throwable)exception);
            throw new DHCPServerInitException("Unable to init server", exception);
        }
    }

    protected void dispatch() {
        try {
            Object object;
            DatagramPacket datagramPacket = new DatagramPacket(new byte[1500], 1500);
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Waiting for packet");
            }
            this.m_aServerSocket.receive(datagramPacket);
            if (s_aLogger.isDebugEnabled()) {
                object = new StringBuilder("Received packet from ");
                Util.appendHostAddress((StringBuilder)object, datagramPacket.getAddress());
                ((StringBuilder)object).append('(').append(datagramPacket.getPort()).append(')');
                s_aLogger.debug(((StringBuilder)object).toString());
            }
            object = new DHCPServletDispatcher(this, this.m_aServlet, datagramPacket);
            this.m_aThreadPool.execute((Runnable)object);
        }
        catch (IOException iOException) {
            s_aLogger.info("IOException", (Throwable)iOException);
        }
    }

    protected void sendResponse(DatagramPacket datagramPacket) {
        if (datagramPacket == null) {
            return;
        }
        try {
            this.m_aServerSocket.send(datagramPacket);
        }
        catch (IOException iOException) {
            s_aLogger.error("IOException", (Throwable)iOException);
        }
    }

    protected InetSocketAddress getInetSocketAddress(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("null props not allowed");
        }
        String string = properties.getProperty(SERVER_ADDRESS);
        if (string == null) {
            throw new IllegalStateException("Cannot load SERVER_ADDRESS property");
        }
        return DHCPCoreServer.parseSocketAddress(string);
    }

    public static InetSocketAddress parseSocketAddress(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null address not allowed");
        }
        int n = string.indexOf(58);
        if (n <= 0) {
            throw new IllegalArgumentException("semicolon missing for port number");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        int n2 = Integer.parseInt(string3);
        return new InetSocketAddress(string2, n2);
    }

    @Override
    public void run() {
        if (this.m_aServerSocket == null) {
            throw new IllegalStateException("Listening socket is not open - terminating");
        }
        while (!this.m_bStopped) {
            try {
                this.dispatch();
            }
            catch (Exception exception) {
                s_aLogger.warn("Unexpected Exception", (Throwable)exception);
            }
        }
    }

    public void stopServer() {
        this.m_bStopped = true;
        this.m_aServerSocket.close();
    }

    public InetSocketAddress getSockAddress() {
        return this.m_aSockAddress;
    }

    static {
        DEF_PROPS.put(SERVER_ADDRESS, SERVER_ADDRESS_DEFAULT);
        DEF_PROPS.put(SERVER_THREADS, SERVER_THREADS_DEFAULT);
        DEF_PROPS.put(SERVER_THREADS_MAX, SERVER_THREADS_MAX_DEFAULT);
        DEF_PROPS.put(SERVER_THREADS_KEEPALIVE, SERVER_THREADS_KEEPALIVE_DEFAULT);
    }

    private static class ServerThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger S_aPoolNumber = new AtomicInteger(1);
        private final AtomicInteger m_aThreadNumber = new AtomicInteger(1);
        private final String m_sNamePrefix = "DHCPCoreServer-" + S_aPoolNumber.getAndIncrement() + "-thread-";

        ServerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, this.m_sNamePrefix + this.m_aThreadNumber.getAndIncrement());
        }
    }
}

