/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;

public class Sample
implements Element<ValueType<?>>,
Serializable {
    private static final long serialVersionUID = 3819211879010998577L;
    private final Timestamp m_timestamp;
    private final Context m_context;
    private final Resource m_resource;
    private final String m_name;
    private final MetricType m_type;
    private final ValueType<?> m_value;
    private final Map<String, String> m_attributes;

    public Sample(Timestamp timestamp, Resource resource, String name, MetricType type, ValueType<?> value) {
        this(timestamp, Context.DEFAULT_CONTEXT, resource, name, type, value, null);
    }

    public Sample(Timestamp timestamp, Resource resource, String name, MetricType type, ValueType<?> value, Map<String, String> attributes) {
        this(timestamp, Context.DEFAULT_CONTEXT, resource, name, type, value, attributes);
    }

    public Sample(Timestamp timestamp, Context context, Resource resource, String name, MetricType type, ValueType<?> value) {
        this(timestamp, context, resource, name, type, value, null);
    }

    public Sample(Timestamp timestamp, Context context, Resource resource, String name, MetricType type, ValueType<?> value, Map<String, String> attributes) {
        this.m_timestamp = (Timestamp)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
        this.m_context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context argument");
        this.m_resource = (Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource");
        this.m_name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.m_type = (MetricType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.m_value = value;
        this.m_attributes = attributes;
    }

    @Override
    public Timestamp getTimestamp() {
        return this.m_timestamp;
    }

    public Context getContext() {
        return this.m_context;
    }

    @Override
    public Resource getResource() {
        return this.m_resource;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public MetricType getType() {
        return this.m_type;
    }

    @Override
    public ValueType<?> getValue() {
        return this.m_value;
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public String toString() {
        return String.format("%s[timestamp=%s, context=%s, resource=%s, name=%s, type=%s, value=%s]", new Object[]{this.getClass().getSimpleName(), this.getTimestamp(), this.getContext(), this.getResource(), this.getName(), this.getType(), this.getValue()});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sample other = (Sample)obj;
        return Objects.equal((Object)this.m_timestamp, (Object)other.m_timestamp) && Objects.equal((Object)this.m_context, (Object)other.m_context) && Objects.equal((Object)this.m_resource, (Object)other.m_resource) && Objects.equal((Object)this.m_name, (Object)other.m_name) && Objects.equal((Object)((Object)this.m_type), (Object)((Object)other.m_type)) && Objects.equal(this.m_value, other.m_value) && Objects.equal(this.m_attributes, other.m_attributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.m_timestamp, this.m_context, this.m_resource, this.m_name, this.m_type, this.m_value, this.m_attributes});
    }
}

