/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.InvalidCollectorVersion;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.UpdateSet;
import com.vmware.vim25.WaitOptions;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.PropertyFilter;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class PropertyCollector
extends ManagedObject {
    public PropertyCollector(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public PropertyFilter[] getFilters() {
        return this.getFilter("filter");
    }

    public void cancelRetrievePropertiesEx(String token) throws InvalidProperty, RuntimeFault, RemoteException {
        this.getVimService().cancelRetrievePropertiesEx(this.getMOR(), token);
    }

    public void cancelWaitForUpdates() throws RuntimeFault, RemoteException {
        this.getVimService().cancelWaitForUpdates(this.getMOR());
    }

    public RetrieveResult continueRetrievePropertiesEx(String token) throws InvalidProperty, RuntimeFault, RemoteException {
        return this.getVimService().continueRetrievePropertiesEx(this.getMOR(), token);
    }

    public UpdateSet checkForUpdates(String version) throws InvalidCollectorVersion, RuntimeFault, RemoteException {
        return this.getVimService().checkForUpdates(this.getMOR(), version);
    }

    public PropertyFilter createFilter(PropertyFilterSpec spec, boolean partialUpdates) throws InvalidProperty, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().createFilter(this.getMOR(), spec, partialUpdates);
        return new PropertyFilter(this.getServerConnection(), mor);
    }

    public PropertyCollector createPropertyCollector() throws RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().createPropertyCollector(this.getMOR());
        return new PropertyCollector(this.getServerConnection(), mor);
    }

    public void destroyPropertyCollector() throws RuntimeFault, RemoteException {
        this.getVimService().destroyPropertyCollector(this.getMOR());
    }

    public ObjectContent[] retrieveProperties(PropertyFilterSpec[] specSet) throws InvalidProperty, RuntimeFault, RemoteException {
        return this.getVimService().retrieveProperties(this.getMOR(), specSet);
    }

    public RetrieveResult retrievePropertiesEx(PropertyFilterSpec[] specSet, RetrieveOptions options) throws InvalidProperty, RuntimeFault, RemoteException {
        return this.getVimService().retrievePropertiesEx(this.getMOR(), specSet, options);
    }

    public UpdateSet waitForUpdates(String version) throws InvalidCollectorVersion, RuntimeFault, RemoteException {
        return this.getVimService().waitForUpdates(this.getMOR(), version);
    }

    public UpdateSet waitForUpdatesEx(String version, WaitOptions options) throws InvalidCollectorVersion, RuntimeFault, RemoteException {
        return this.getVimService().waitForUpdatesEx(this.getMOR(), version, options);
    }
}

