/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

public class JsonHttpCommandCodec
implements CommandCodec<HttpRequest> {
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private static final String SESSION_ID_PARAM = "sessionId";
    private final BiMap<String, CommandSpec> nameToSpec = HashBiMap.create();
    private final BeanToJsonConverter beanToJsonConverter = new BeanToJsonConverter();
    private final JsonToBeanConverter jsonToBeanConverter = new JsonToBeanConverter();

    public JsonHttpCommandCodec() {
        this.defineCommand("status", JsonHttpCommandCodec.get("/status"));
        this.defineCommand("getAllSessions", JsonHttpCommandCodec.get("/sessions"));
        this.defineCommand("newSession", JsonHttpCommandCodec.post("/session"));
        this.defineCommand("getCapabilities", JsonHttpCommandCodec.get("/session/:sessionId"));
        this.defineCommand("quit", JsonHttpCommandCodec.delete("/session/:sessionId"));
        this.defineCommand("getSessionLogs", JsonHttpCommandCodec.post("/logs"));
        this.defineCommand("getLog", JsonHttpCommandCodec.post("/session/:sessionId/log"));
        this.defineCommand("getAvailableLogTypes", JsonHttpCommandCodec.get("/session/:sessionId/log/types"));
        this.defineCommand("switchToFrame", JsonHttpCommandCodec.post("/session/:sessionId/frame"));
        this.defineCommand("switchToParentFrame", JsonHttpCommandCodec.post("/session/:sessionId/frame/parent"));
        this.defineCommand("close", JsonHttpCommandCodec.delete("/session/:sessionId/window"));
        this.defineCommand("switchToWindow", JsonHttpCommandCodec.post("/session/:sessionId/window"));
        this.defineCommand("getWindowHandles", JsonHttpCommandCodec.get("/session/:sessionId/window_handles"));
        this.defineCommand("maximizeWindow", JsonHttpCommandCodec.post("/session/:sessionId/window/:windowHandle/maximize"));
        this.defineCommand("getWindowSize", JsonHttpCommandCodec.get("/session/:sessionId/window/:windowHandle/size"));
        this.defineCommand("setWindowSize", JsonHttpCommandCodec.post("/session/:sessionId/window/:windowHandle/size"));
        this.defineCommand("getWindowPosition", JsonHttpCommandCodec.get("/session/:sessionId/window/:windowHandle/position"));
        this.defineCommand("setWindowPosition", JsonHttpCommandCodec.post("/session/:sessionId/window/:windowHandle/position"));
        this.defineCommand("getCurrentWindowHandle", JsonHttpCommandCodec.get("/session/:sessionId/window_handle"));
        this.defineCommand("maximizeCurrentWindow", JsonHttpCommandCodec.post("/session/:sessionId/window/maximize"));
        this.defineCommand("fullscreenCurrentWindow", JsonHttpCommandCodec.post("/session/:sessionId/window/fullscreen"));
        this.defineCommand("getCurrentWindowSize", JsonHttpCommandCodec.get("/session/:sessionId/window/size"));
        this.defineCommand("setCurrentWindowSize", JsonHttpCommandCodec.post("/session/:sessionId/window/size"));
        this.defineCommand("getWindowHandlesW3C", JsonHttpCommandCodec.get("/session/:sessionId/window/handles"));
        this.defineCommand("getCurrentWindowHandleW3C", JsonHttpCommandCodec.get("/session/:sessionId/window"));
        this.defineCommand("getCurrentUrl", JsonHttpCommandCodec.get("/session/:sessionId/url"));
        this.defineCommand("get", JsonHttpCommandCodec.post("/session/:sessionId/url"));
        this.defineCommand("goBack", JsonHttpCommandCodec.post("/session/:sessionId/back"));
        this.defineCommand("goForward", JsonHttpCommandCodec.post("/session/:sessionId/forward"));
        this.defineCommand("refresh", JsonHttpCommandCodec.post("/session/:sessionId/refresh"));
        this.defineCommand("acceptAlert", JsonHttpCommandCodec.post("/session/:sessionId/accept_alert"));
        this.defineCommand("dismissAlert", JsonHttpCommandCodec.post("/session/:sessionId/dismiss_alert"));
        this.defineCommand("getAlertText", JsonHttpCommandCodec.get("/session/:sessionId/alert_text"));
        this.defineCommand("setAlertValue", JsonHttpCommandCodec.post("/session/:sessionId/alert_text"));
        this.defineCommand("acceptAlertW3C", JsonHttpCommandCodec.post("/session/:sessionId/alert/accept"));
        this.defineCommand("dimissAlertW3C", JsonHttpCommandCodec.post("/session/:sessionId/alert/dismiss"));
        this.defineCommand("getAlertTextW3C", JsonHttpCommandCodec.get("/session/:sessionId/alert/text"));
        this.defineCommand("setAlertValueW3C", JsonHttpCommandCodec.post("/session/:sessionId/alert/text"));
        this.defineCommand("setAlertCredentials", JsonHttpCommandCodec.post("/session/:sessionId/alert/credentials"));
        this.defineCommand("executeScript", JsonHttpCommandCodec.post("/session/:sessionId/execute"));
        this.defineCommand("executeAsyncScript", JsonHttpCommandCodec.post("/session/:sessionId/execute_async"));
        this.defineCommand("executeScriptW3C", JsonHttpCommandCodec.post("/session/:sessionId/execute/sync"));
        this.defineCommand("executeAsyncScriptW3C", JsonHttpCommandCodec.post("/session/:sessionId/execute/async"));
        this.defineCommand("uploadFile", JsonHttpCommandCodec.post("/session/:sessionId/file"));
        this.defineCommand("screenshot", JsonHttpCommandCodec.get("/session/:sessionId/screenshot"));
        this.defineCommand("elementScreenshot", JsonHttpCommandCodec.get("/session/:sessionId/screenshot/:id"));
        this.defineCommand("getPageSource", JsonHttpCommandCodec.get("/session/:sessionId/source"));
        this.defineCommand("getTitle", JsonHttpCommandCodec.get("/session/:sessionId/title"));
        this.defineCommand("findElement", JsonHttpCommandCodec.post("/session/:sessionId/element"));
        this.defineCommand("findElements", JsonHttpCommandCodec.post("/session/:sessionId/elements"));
        this.defineCommand("getActiveElement", JsonHttpCommandCodec.post("/session/:sessionId/element/active"));
        this.defineCommand("getElementAttribute", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/attribute/:name"));
        this.defineCommand("clickElement", JsonHttpCommandCodec.post("/session/:sessionId/element/:id/click"));
        this.defineCommand("clearElement", JsonHttpCommandCodec.post("/session/:sessionId/element/:id/clear"));
        this.defineCommand("getElementValueOfCssProperty", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/css/:propertyName"));
        this.defineCommand("isElementDisplayed", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/displayed"));
        this.defineCommand("findChildElement", JsonHttpCommandCodec.post("/session/:sessionId/element/:id/element"));
        this.defineCommand("findChildElements", JsonHttpCommandCodec.post("/session/:sessionId/element/:id/elements"));
        this.defineCommand("isElementEnabled", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/enabled"));
        this.defineCommand("elementEquals", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/equals/:other"));
        this.defineCommand("getElementRect", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/rect"));
        this.defineCommand("getElementLocation", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/location"));
        this.defineCommand("getElementLocationOnceScrolledIntoView", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/location_in_view"));
        this.defineCommand("getElementTagName", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/name"));
        this.defineCommand("isElementSelected", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/selected"));
        this.defineCommand("getElementSize", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/size"));
        this.defineCommand("submitElement", JsonHttpCommandCodec.post("/session/:sessionId/element/:id/submit"));
        this.defineCommand("getElementText", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/text"));
        this.defineCommand("sendKeysToElement", JsonHttpCommandCodec.post("/session/:sessionId/element/:id/value"));
        this.defineCommand("getCookies", JsonHttpCommandCodec.get("/session/:sessionId/cookie"));
        this.defineCommand("getCookie", JsonHttpCommandCodec.get("/session/:sessionId/cookie/:name"));
        this.defineCommand("addCookie", JsonHttpCommandCodec.post("/session/:sessionId/cookie"));
        this.defineCommand("deleteAllCookies", JsonHttpCommandCodec.delete("/session/:sessionId/cookie"));
        this.defineCommand("deleteCookie", JsonHttpCommandCodec.delete("/session/:sessionId/cookie/:name"));
        this.defineCommand("setTimeout", JsonHttpCommandCodec.post("/session/:sessionId/timeouts"));
        this.defineCommand("setScriptTimeout", JsonHttpCommandCodec.post("/session/:sessionId/timeouts/async_script"));
        this.defineCommand("implicitlyWait", JsonHttpCommandCodec.post("/session/:sessionId/timeouts/implicit_wait"));
        this.defineCommand("getStatus", JsonHttpCommandCodec.get("/session/:sessionId/application_cache/status"));
        this.defineCommand("isBrowserOnline", JsonHttpCommandCodec.get("/session/:sessionId/browser_connection"));
        this.defineCommand("setBrowserOnline", JsonHttpCommandCodec.post("/session/:sessionId/browser_connection"));
        this.defineCommand("getLocation", JsonHttpCommandCodec.get("/session/:sessionId/location"));
        this.defineCommand("setLocation", JsonHttpCommandCodec.post("/session/:sessionId/location"));
        this.defineCommand("clearLocalStorage", JsonHttpCommandCodec.delete("/session/:sessionId/local_storage"));
        this.defineCommand("getLocalStorageKeys", JsonHttpCommandCodec.get("/session/:sessionId/local_storage"));
        this.defineCommand("setLocalStorageItem", JsonHttpCommandCodec.post("/session/:sessionId/local_storage"));
        this.defineCommand("removeLocalStorageItem", JsonHttpCommandCodec.delete("/session/:sessionId/local_storage/key/:key"));
        this.defineCommand("getLocalStorageItem", JsonHttpCommandCodec.get("/session/:sessionId/local_storage/key/:key"));
        this.defineCommand("getLocalStorageSize", JsonHttpCommandCodec.get("/session/:sessionId/local_storage/size"));
        this.defineCommand("clearSessionStorage", JsonHttpCommandCodec.delete("/session/:sessionId/session_storage"));
        this.defineCommand("getSessionStorageKey", JsonHttpCommandCodec.get("/session/:sessionId/session_storage"));
        this.defineCommand("setSessionStorageItem", JsonHttpCommandCodec.post("/session/:sessionId/session_storage"));
        this.defineCommand("removeSessionStorageItem", JsonHttpCommandCodec.delete("/session/:sessionId/session_storage/key/:key"));
        this.defineCommand("getSessionStorageItem", JsonHttpCommandCodec.get("/session/:sessionId/session_storage/key/:key"));
        this.defineCommand("getSessionStorageSize", JsonHttpCommandCodec.get("/session/:sessionId/session_storage/size"));
        this.defineCommand("getScreenOrientation", JsonHttpCommandCodec.get("/session/:sessionId/orientation"));
        this.defineCommand("setScreenOrientation", JsonHttpCommandCodec.post("/session/:sessionId/orientation"));
        this.defineCommand("mouseButtonDown", JsonHttpCommandCodec.post("/session/:sessionId/buttondown"));
        this.defineCommand("mouseButtonUp", JsonHttpCommandCodec.post("/session/:sessionId/buttonup"));
        this.defineCommand("mouseClick", JsonHttpCommandCodec.post("/session/:sessionId/click"));
        this.defineCommand("mouseDoubleClick", JsonHttpCommandCodec.post("/session/:sessionId/doubleclick"));
        this.defineCommand("mouseMoveTo", JsonHttpCommandCodec.post("/session/:sessionId/moveto"));
        this.defineCommand("sendKeysToActiveElement", JsonHttpCommandCodec.post("/session/:sessionId/keys"));
        this.defineCommand("touchSingleTap", JsonHttpCommandCodec.post("/session/:sessionId/touch/click"));
        this.defineCommand("touchDoubleTap", JsonHttpCommandCodec.post("/session/:sessionId/touch/doubleclick"));
        this.defineCommand("touchDown", JsonHttpCommandCodec.post("/session/:sessionId/touch/down"));
        this.defineCommand("touchFlick", JsonHttpCommandCodec.post("/session/:sessionId/touch/flick"));
        this.defineCommand("touchLongPress", JsonHttpCommandCodec.post("/session/:sessionId/touch/longclick"));
        this.defineCommand("touchMove", JsonHttpCommandCodec.post("/session/:sessionId/touch/move"));
        this.defineCommand("touchScroll", JsonHttpCommandCodec.post("/session/:sessionId/touch/scroll"));
        this.defineCommand("touchUp", JsonHttpCommandCodec.post("/session/:sessionId/touch/up"));
        this.defineCommand("imeGetAvailableEngines", JsonHttpCommandCodec.get("/session/:sessionId/ime/available_engines"));
        this.defineCommand("imeGetActiveEngine", JsonHttpCommandCodec.get("/session/:sessionId/ime/active_engine"));
        this.defineCommand("imeIsActivated", JsonHttpCommandCodec.get("/session/:sessionId/ime/activated"));
        this.defineCommand("imeDeactivate", JsonHttpCommandCodec.post("/session/:sessionId/ime/deactivate"));
        this.defineCommand("imeActivateEngine", JsonHttpCommandCodec.post("/session/:sessionId/ime/activate"));
        this.defineCommand("getNetworkConnection", JsonHttpCommandCodec.get("/session/:sessionId/network_connection"));
        this.defineCommand("setNetworkConnection", JsonHttpCommandCodec.post("/session/:sessionId/network_connection"));
        this.defineCommand("switchToContext", JsonHttpCommandCodec.post("/session/:sessionId/context"));
        this.defineCommand("getCurrentContextHandle", JsonHttpCommandCodec.get("/session/:sessionId/context"));
        this.defineCommand("getContextHandles", JsonHttpCommandCodec.get("/session/:sessionId/contexts"));
    }

    @Override
    public HttpRequest encode(Command command) {
        CommandSpec spec = (CommandSpec)this.nameToSpec.get((Object)command.getName());
        if (spec == null) {
            throw new UnsupportedCommandException(command.getName());
        }
        String uri = this.buildUri(command, spec);
        HttpRequest request = new HttpRequest(spec.method, uri);
        if (HttpMethod.POST == spec.method) {
            String content = this.beanToJsonConverter.convert(command.getParameters());
            byte[] data = content.getBytes(Charsets.UTF_8);
            request.setHeader("Content-Length", String.valueOf(data.length));
            request.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
            request.setContent(data);
        }
        if (HttpMethod.GET == spec.method) {
            request.setHeader("Cache-Control", "no-cache");
        }
        return request;
    }

    @Override
    public Command decode(final HttpRequest encodedCommand) {
        String id;
        String path = Strings.isNullOrEmpty((String)encodedCommand.getUri()) ? "/" : encodedCommand.getUri();
        final ImmutableList parts = ImmutableList.copyOf((Iterable)PATH_SPLITTER.split((CharSequence)path));
        ImmutableList matchingSpecs = FluentIterable.from((Iterable)this.nameToSpec.inverse().keySet()).filter((Predicate)new Predicate<CommandSpec>(){

            public boolean apply(CommandSpec spec) {
                return spec.isFor(encodedCommand.getMethod(), (ImmutableList<String>)parts);
            }
        }).toSortedList((Comparator)new Comparator<CommandSpec>(){

            @Override
            public int compare(CommandSpec a, CommandSpec b) {
                return a.pathSegments.size() - b.pathSegments.size();
            }
        });
        if (matchingSpecs.isEmpty()) {
            throw new UnsupportedCommandException((Object)((Object)encodedCommand.getMethod()) + " " + encodedCommand.getUri());
        }
        CommandSpec spec = (CommandSpec)matchingSpecs.get(0);
        HashMap parameters = Maps.newHashMap();
        spec.parsePathParameters((ImmutableList<String>)parts, parameters);
        String content = encodedCommand.getContentString();
        if (!content.isEmpty()) {
            HashMap tmp = this.jsonToBeanConverter.convert(HashMap.class, content);
            parameters.putAll(tmp);
        }
        String name = (String)this.nameToSpec.inverse().get((Object)spec);
        SessionId sessionId = null;
        if (parameters.containsKey(SESSION_ID_PARAM) && (id = (String)parameters.remove(SESSION_ID_PARAM)) != null) {
            sessionId = new SessionId(id);
        }
        return new Command(sessionId, name, parameters);
    }

    public void defineCommand(String name, HttpMethod method, String pathPattern) {
        this.defineCommand(name, new CommandSpec(method, pathPattern));
    }

    private void defineCommand(String name, CommandSpec spec) {
        Preconditions.checkNotNull((Object)name, (Object)"null name");
        this.nameToSpec.put((Object)name, (Object)spec);
    }

    private static CommandSpec delete(String path) {
        return new CommandSpec(HttpMethod.DELETE, path);
    }

    private static CommandSpec get(String path) {
        return new CommandSpec(HttpMethod.GET, path);
    }

    private static CommandSpec post(String path) {
        return new CommandSpec(HttpMethod.POST, path);
    }

    private String buildUri(Command command, CommandSpec spec) {
        StringBuilder builder = new StringBuilder();
        for (String part : spec.pathSegments) {
            if (part.isEmpty()) continue;
            builder.append("/");
            if (part.startsWith(":")) {
                builder.append(this.getParameter(part.substring(1), command));
                continue;
            }
            builder.append(part);
        }
        return builder.toString();
    }

    private String getParameter(String parameterName, Command command) {
        if (SESSION_ID_PARAM.equals(parameterName)) {
            SessionId id = command.getSessionId();
            Preconditions.checkArgument((id != null ? 1 : 0) != 0, (String)"Session ID may not be null for command %s", (Object[])new Object[]{command.getName()});
            return id.toString();
        }
        Object value = command.getParameters().get(parameterName);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Missing required parameter \"%s\" for command %s", (Object[])new Object[]{parameterName, command.getName()});
        return Urls.urlEncode(String.valueOf(value));
    }

    private static class CommandSpec {
        private final HttpMethod method;
        private final String path;
        private final ImmutableList<String> pathSegments;

        private CommandSpec(HttpMethod method, String path) {
            this.method = (HttpMethod)((Object)Preconditions.checkNotNull((Object)((Object)method), (Object)"null method"));
            this.path = path;
            this.pathSegments = ImmutableList.copyOf((Iterable)PATH_SPLITTER.split((CharSequence)path));
        }

        public boolean equals(Object o) {
            if (o instanceof CommandSpec) {
                CommandSpec that = (CommandSpec)o;
                return this.method.equals((Object)that.method) && this.path.equals(that.path);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.method, this.path});
        }

        boolean isFor(HttpMethod method, ImmutableList<String> parts) {
            if (!this.method.equals((Object)method)) {
                return false;
            }
            if (parts.size() != this.pathSegments.size()) {
                return false;
            }
            for (int i = 0; i < parts.size(); ++i) {
                String reqPart = (String)parts.get(i);
                String specPart = (String)this.pathSegments.get(i);
                if (specPart.startsWith(":") || specPart.equals(reqPart)) continue;
                return false;
            }
            return true;
        }

        void parsePathParameters(ImmutableList<String> parts, Map<String, Object> parameters) {
            for (int i = 0; i < parts.size(); ++i) {
                if (!((String)this.pathSegments.get(i)).startsWith(":")) continue;
                parameters.put(((String)this.pathSegments.get(i)).substring(1), parts.get(i));
            }
        }
    }
}

