/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.RelaxedX509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SocketUtils.class);

    public static Socket wrapSocketInSslContext(Socket socket) throws IOException {
        return SocketUtils.wrapSocketInSslContext(socket, null, null);
    }

    public static SSLSocket wrapSocketInSslContext(Socket socket, String protocol) throws IOException {
        return SocketUtils.wrapSocketInSslContext(socket, protocol, null);
    }

    public static SSLSocket wrapSocketInSslContext(Socket socket, String protocol, String[] cipherSuites) throws IOException {
        TrustManager[] tm = new TrustManager[]{new RelaxedX509ExtendedTrustManager()};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance(protocol == null ? "SSL" : protocol);
            sslContext.init(null, tm, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("wrapSocket: Error wrapping socket, throwing runtime exception", (Throwable)e);
            throw new IllegalStateException("No such algorithm in SSLSocketFactory: " + String.valueOf(e));
        }
        catch (KeyManagementException e) {
            LOG.error("wrapSocket: Error wrapping socket, throwing runtime exception", (Throwable)e);
            throw new IllegalStateException("Key management exception in SSLSocketFactory: " + String.valueOf(e));
        }
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        InetAddress inetAddress = socket.getInetAddress();
        String hostAddress = InetAddressUtils.str(inetAddress);
        SSLSocket wrappedSocket = (SSLSocket)socketFactory.createSocket(socket, hostAddress, socket.getPort(), true);
        if (cipherSuites != null && cipherSuites.length > 0) {
            wrappedSocket.setEnabledCipherSuites(cipherSuites);
        }
        return wrappedSocket;
    }

    public static boolean validResponse(String request, String responsePattern, BufferedReader r, Writer wr) throws IOException {
        boolean validResponse = true;
        if (!Strings.isNullOrEmpty((String)request) && !Strings.isNullOrEmpty((String)responsePattern)) {
            Object l = null;
            validResponse = false;
            LOG.debug("writing {}, hoping response matches /{}/", (Object)request, (Object)responsePattern);
            wr.write(request);
            wr.flush();
            Pattern p = Pattern.compile(responsePattern);
            StringBuilder sb = new StringBuilder();
            try {
                int i;
                while ((i = r.read()) != -1) {
                    sb.append((char)i);
                }
            }
            catch (InterruptedIOException e) {
                LOG.debug("response was: {}", (Object)sb.toString());
            }
            validResponse = p.matcher(sb.toString()).matches();
        }
        return validResponse;
    }
}

