/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.bean;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.core.RetrievalUtils;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;
import org.extremecomponents.util.ExtremeUtils;

final class ColumnDefaults {
    private static Log logger = LogFactory.getLog(ColumnDefaults.class);

    private ColumnDefaults() {
    }

    static String getCell(TableModel model, String cell) {
        String result;
        if (StringUtils.isNotBlank((CharSequence)cell)) {
            result = model.getPreferences().getPreference("column.cell." + cell);
            if (StringUtils.isBlank((CharSequence)result)) {
                result = cell;
            }
        } else {
            result = model.getPreferences().getPreference("column.cell.display");
        }
        return result;
    }

    static String getFilterCell(TableModel model, String filterCell) {
        String result;
        if (StringUtils.isNotBlank((CharSequence)filterCell)) {
            result = model.getPreferences().getPreference("column.filterCell." + filterCell);
            if (StringUtils.isBlank((CharSequence)result)) {
                result = filterCell;
            }
        } else {
            result = model.getPreferences().getPreference("column.filterCell.filter");
        }
        return result;
    }

    static String getHeaderCell(TableModel model, String headerCell) {
        String result;
        if (StringUtils.isNotBlank((CharSequence)headerCell)) {
            result = model.getPreferences().getPreference("column.headerCell." + headerCell);
            if (StringUtils.isBlank((CharSequence)result)) {
                result = headerCell;
            }
        } else {
            result = model.getPreferences().getPreference("column.headerCell.header");
        }
        return result;
    }

    static String getParse(TableModel model, Column column, String parse) {
        if (StringUtils.isNotBlank((CharSequence)parse)) {
            return parse;
        }
        if (column.isDate()) {
            return model.getPreferences().getPreference("column.parse.date");
        }
        return parse;
    }

    static String getFormat(TableModel model, Column column, String format) {
        String result = ColumnDefaults.getFormatInResourceBundle(model, column, format);
        if (StringUtils.isBlank((CharSequence)result)) {
            result = ColumnDefaults.getFormatInProperties(model, column, format);
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return result;
        }
        return format;
    }

    static String getFormatInResourceBundle(TableModel model, Column column, String format) {
        if (StringUtils.isNotBlank((CharSequence)format) && ColumnDefaults.isNamedFormat(format)) {
            return model.getMessages().getMessage("column.format." + format);
        }
        if (StringUtils.isBlank((CharSequence)format)) {
            if (column.isCurrency()) {
                return model.getMessages().getMessage("column.format.currency");
            }
            if (column.isDate()) {
                return model.getMessages().getMessage("column.format.date");
            }
        }
        return null;
    }

    static String getFormatInProperties(TableModel model, Column column, String format) {
        if (StringUtils.isNotBlank((CharSequence)format) && ColumnDefaults.isNamedFormat(format)) {
            return model.getPreferences().getPreference("column.format." + format);
        }
        if (StringUtils.isBlank((CharSequence)format)) {
            if (column.isCurrency()) {
                return model.getPreferences().getPreference("column.format.currency");
            }
            if (column.isDate()) {
                return model.getPreferences().getPreference("column.format.date");
            }
        }
        return null;
    }

    static boolean isNamedFormat(String format) {
        char[] args = new char[]{'#', '/', '-'};
        return StringUtils.containsNone((CharSequence)format, (char[])args);
    }

    static Boolean isSortable(TableModel model, Boolean sortable) {
        if (sortable == null) {
            return model.getTableHandler().getTable().isSortable();
        }
        return sortable;
    }

    static Boolean isFilterable(TableModel model, Boolean filterable) {
        if (filterable == null) {
            return model.getTableHandler().getTable().isFilterable();
        }
        return filterable;
    }

    static String getTitle(TableModel model, String title, String property) {
        String resourceValue;
        if (StringUtils.isEmpty((CharSequence)title)) {
            return ExtremeUtils.camelCaseToWord(property);
        }
        if (TableModelUtils.isResourceBundleProperty(title) && (resourceValue = model.getMessages().getMessage(title)) != null) {
            return resourceValue;
        }
        return title;
    }

    static String getHeaderClass(TableModel model, String headerClass) {
        if (StringUtils.isBlank((CharSequence)headerClass)) {
            return model.getPreferences().getPreference("table.headerClass");
        }
        return headerClass;
    }

    static String getAlias(String alias, String property) {
        if (StringUtils.isBlank((CharSequence)alias) && StringUtils.isNotBlank((CharSequence)property)) {
            return property;
        }
        return alias;
    }

    public static String[] getCalcTitle(TableModel model, String[] calcTitle) {
        ArrayList<String> results = new ArrayList<String>();
        if (calcTitle == null) {
            return new String[0];
        }
        for (int i = 0; i < calcTitle.length; ++i) {
            String title = calcTitle[i];
            if (TableModelUtils.isResourceBundleProperty(title)) {
                String resourceValue = model.getMessages().getMessage(title);
                if (resourceValue == null) {
                    resourceValue = title;
                }
                if (!StringUtils.isNotBlank((CharSequence)resourceValue)) continue;
                results.add(resourceValue);
                continue;
            }
            results.add(title);
        }
        return results.toArray(new String[results.size()]);
    }

    static Boolean isEscapeAutoFormat(TableModel model, Boolean escapeAutoFormat) {
        if (escapeAutoFormat == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("column.escapeAutoFormat"));
        }
        return escapeAutoFormat;
    }

    static Object getFilterOptions(TableModel model, Object filterOptions) {
        if (model == null) {
            return null;
        }
        try {
            if (filterOptions != null) {
                return RetrievalUtils.retrieveCollection(model.getContext(), filterOptions);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("unable to retrieve collection for context " + model.getContext()), (Throwable)e);
        }
        return null;
    }
}

