/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka;

import java.util.Map;
import java.util.Properties;
import org.opennms.core.ipc.common.kafka.KafkaConfigProvider;
import org.opennms.core.utils.SystemInfoUtils;

public class OnmsKafkaConfigProvider
implements KafkaConfigProvider {
    private final String kafkaSysPropPrefix;
    private final String commonKafkaSysPropPrefix;

    public OnmsKafkaConfigProvider(String kafkaSysPropPrefix) {
        this.kafkaSysPropPrefix = kafkaSysPropPrefix;
        this.commonKafkaSysPropPrefix = null;
    }

    public OnmsKafkaConfigProvider(String kafkaSysPropPrefix, String commonKafkaSysPropPrefix) {
        this.kafkaSysPropPrefix = kafkaSysPropPrefix;
        this.commonKafkaSysPropPrefix = commonKafkaSysPropPrefix;
    }

    @Override
    public Properties getProperties() {
        Properties kafkaConfig = new Properties();
        kafkaConfig.put("group.id", SystemInfoUtils.getInstanceId());
        Properties config = this.loadKafkaConfigFromSysPropPrefix(this.kafkaSysPropPrefix);
        if (config.containsKey("bootstrap.servers")) {
            kafkaConfig.putAll((Map<?, ?>)config);
        } else if (this.commonKafkaSysPropPrefix != null) {
            Properties fallbackConfig = this.loadKafkaConfigFromSysPropPrefix(this.commonKafkaSysPropPrefix);
            kafkaConfig.putAll((Map<?, ?>)fallbackConfig);
        }
        return kafkaConfig;
    }

    private Properties loadKafkaConfigFromSysPropPrefix(String kafkaSysPropPrefix) {
        Properties kafkaConfig = new Properties();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key;
            Object keyAsObject = entry.getKey();
            if (keyAsObject == null || !(keyAsObject instanceof String) || (key = (String)keyAsObject).length() <= kafkaSysPropPrefix.length() || !key.startsWith(kafkaSysPropPrefix)) continue;
            String kafkaConfigKey = key.substring(kafkaSysPropPrefix.length());
            kafkaConfig.put(kafkaConfigKey, entry.getValue());
        }
        return kafkaConfig;
    }
}

