/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.session;

import java.util.Arrays;

public class SequenceNumberTracker {
    private long current;
    private final Ring seen;

    public SequenceNumberTracker(int patience) {
        if (patience < 0) {
            throw new IllegalArgumentException("patience must be positive");
        }
        this.seen = patience > 1 ? new Ring(patience) : null;
        this.current = Integer.MIN_VALUE;
    }

    public synchronized boolean verify(long sequenceNumber) {
        if (this.seen == null) {
            return true;
        }
        if (Math.abs(this.current - sequenceNumber) > (long)this.seen.size()) {
            this.current = sequenceNumber;
            this.seen.reset(true);
            return true;
        }
        if (sequenceNumber < this.current) {
            this.seen.set(sequenceNumber, true);
            return true;
        }
        boolean valid = this.seen.set(sequenceNumber, true);
        for (long x = this.current + 1L; x < sequenceNumber; ++x) {
            valid &= this.seen.set(x, false);
        }
        this.current = sequenceNumber;
        return valid;
    }

    public int getPatience() {
        return this.seen.size();
    }

    private static class Ring {
        private final boolean[] values;

        private Ring(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("ring size must be >= 1");
            }
            this.values = new boolean[size];
        }

        public void reset(boolean value) {
            Arrays.fill(this.values, value);
        }

        public boolean set(long index, boolean value) {
            int wrapped = (int)(index % (long)this.values.length);
            boolean prev = this.values[wrapped];
            this.values[wrapped] = value;
            return prev;
        }

        public int size() {
            return this.values.length;
        }
    }
}

