/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElement;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Semantics;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;

public class UnsignedValue
extends Value<UnsignedLong> {
    private final UnsignedLong value;

    public UnsignedValue(String name, Optional<Semantics> semantics, UnsignedLong value) {
        super(name, semantics);
        this.value = Objects.requireNonNull(value);
    }

    public UnsignedValue(String name, long value) {
        this(name, Optional.empty(), UnsignedLong.valueOf((long)value));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("value", (Object)this.value).toString();
    }

    public static InformationElement parserWith8Bit(InformationElementDatabase database, final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(InformationElementDatabase database, Session.Resolver resolver, ByteBuf buffer) {
                return new UnsignedValue(name, semantics, BufferUtils.uint((ByteBuf)buffer, (int)1));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 1;
            }
        };
    }

    public static InformationElement parserWith16Bit(InformationElementDatabase database, final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(InformationElementDatabase database, Session.Resolver resolver, ByteBuf buffer) {
                return new UnsignedValue(name, semantics, BufferUtils.uint((ByteBuf)buffer, (int)buffer.readableBytes()));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 2;
            }
        };
    }

    public static InformationElement parserWith24Bit(InformationElementDatabase database, final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(InformationElementDatabase database, Session.Resolver resolver, ByteBuf buffer) {
                return new UnsignedValue(name, semantics, BufferUtils.uint((ByteBuf)buffer, (int)buffer.readableBytes()));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 3;
            }
        };
    }

    public static InformationElement parserWith32Bit(InformationElementDatabase database, final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(InformationElementDatabase database, Session.Resolver resolver, ByteBuf buffer) {
                return new UnsignedValue(name, semantics, BufferUtils.uint((ByteBuf)buffer, (int)buffer.readableBytes()));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 4;
            }
        };
    }

    public static InformationElement parserWith64Bit(InformationElementDatabase database, final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(InformationElementDatabase database, Session.Resolver resolver, ByteBuf buffer) {
                return new UnsignedValue(name, semantics, BufferUtils.uint((ByteBuf)buffer, (int)buffer.readableBytes()));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 8;
            }
        };
    }

    @Override
    public UnsignedLong getValue() {
        return this.value;
    }

    @Override
    public void visit(Value.Visitor visitor) {
        visitor.accept(this);
    }
}

