/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.listeners.TcpParser;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ParserBase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Header;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Packet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.TcpSession;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.state.ParserState;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.IpFixMessageBuilder;

public class IpfixTcpParser
extends ParserBase
implements TcpParser {
    private final IpFixMessageBuilder messageBuilder = new IpFixMessageBuilder();
    private final Set<TcpSession> sessions = Sets.newConcurrentHashSet();
    private final InformationElementDatabase informationElementDatabase;

    public IpfixTcpParser(String name, AsyncDispatcher<TelemetryMessage> dispatcher, EventForwarder eventForwarder, Identity identity, DnsResolver dnsResolver, MetricRegistry metricRegistry, InformationElementDatabase informationElementDatabase) {
        super(Protocol.IPFIX, name, dispatcher, eventForwarder, identity, dnsResolver, metricRegistry);
        this.informationElementDatabase = informationElementDatabase;
    }

    @Override
    public IpFixMessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public TcpParser.Handler accept(final InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        final TcpSession session = new TcpSession(remoteAddress.getAddress(), this::sequenceNumberTracker);
        return new TcpParser.Handler(){

            public Optional<CompletableFuture<?>> parse(ByteBuf buffer) throws Exception {
                buffer.markReaderIndex();
                if (!buffer.isReadable(16)) {
                    buffer.resetReaderIndex();
                    return Optional.empty();
                }
                Header header = new Header(BufferUtils.slice((ByteBuf)buffer, (int)16));
                if (!buffer.isReadable(header.payloadLength())) {
                    buffer.resetReaderIndex();
                    return Optional.empty();
                }
                Packet packet = new Packet(IpfixTcpParser.this.informationElementDatabase, session, header, BufferUtils.slice((ByteBuf)buffer, (int)header.payloadLength()));
                IpfixTcpParser.this.detectClockSkew(header.exportTime * 1000L, session.getRemoteAddress());
                return Optional.of(IpfixTcpParser.this.transmit(packet, session, remoteAddress));
            }

            public void active() {
                IpfixTcpParser.this.sessions.add(session);
            }

            public void inactive() {
                IpfixTcpParser.this.sessions.remove(session);
            }
        };
    }

    public Long getFlowActiveTimeoutFallback() {
        return this.messageBuilder.getFlowActiveTimeoutFallback();
    }

    public void setFlowActiveTimeoutFallback(Long flowActiveTimeoutFallback) {
        this.messageBuilder.setFlowActiveTimeoutFallback(flowActiveTimeoutFallback);
    }

    public Long getFlowInactiveTimeoutFallback() {
        return this.messageBuilder.getFlowInactiveTimeoutFallback();
    }

    public void setFlowInactiveTimeoutFallback(Long flowInactiveTimeoutFallback) {
        this.messageBuilder.setFlowInactiveTimeoutFallback(flowInactiveTimeoutFallback);
    }

    public Long getFlowSamplingIntervalFallback() {
        return this.messageBuilder.getFlowSamplingIntervalFallback();
    }

    public void setFlowSamplingIntervalFallback(Long flowSamplingIntervalFallback) {
        this.messageBuilder.setFlowSamplingIntervalFallback(flowSamplingIntervalFallback);
    }

    public Object dumpInternalState() {
        ParserState.Builder parser = ParserState.builder();
        this.sessions.stream().flatMap(TcpSession::dumpInternalState).forEach(parser::withExporter);
        return parser.build();
    }
}

