/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.node;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.Match;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.providers.SearchResultItemBuilder;

public class NodeLabelSearchProvider
implements SearchProvider {
    private final NodeDao nodeDao;
    private final EntityScopeProvider entityScopeProvider;

    public NodeLabelSearchProvider(NodeDao nodeDao, EntityScopeProvider entityScopeProvider) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.entityScopeProvider = Objects.requireNonNull(entityScopeProvider);
    }

    public SearchContext getContext() {
        return Contexts.Node;
    }

    public SearchResult query(SearchQuery query) {
        String input = query.getInput();
        ArrayList restrictions = Lists.newArrayList((Object[])new Restriction[]{Restrictions.ilike((String)"label", (Object)QueryUtils.ilike((String)input)), Restrictions.eq((String)"foreignSource", (Object)input), Restrictions.eq((String)"foreignId", (Object)input)});
        try {
            int nodeId = Integer.parseInt(input);
            restrictions.add(Restrictions.eq((String)"id", (Object)nodeId));
        }
        catch (NumberFormatException nodeId) {
            // empty catch block
        }
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class).or(restrictions.toArray(new Restriction[restrictions.size()])).distinct();
        int totalCount = this.nodeDao.countMatching(criteriaBuilder.toCriteria());
        Criteria criteria = criteriaBuilder.orderBy("label").limit(Integer.valueOf(query.getMaxResults())).toCriteria();
        List matchingNodes = this.nodeDao.findMatching(criteria);
        List searchResultItems = matchingNodes.stream().map(node -> {
            SearchResultItem searchResultItem = new SearchResultItemBuilder().withOnmsNode((OnmsNode)node, this.entityScopeProvider).build();
            if (QueryUtils.equals((Integer)node.getId(), (String)input)) {
                searchResultItem.addMatch(new Match("id", "Node ID", node.getId().toString()));
            }
            if (QueryUtils.matches((String)node.getForeignId(), (String)input)) {
                searchResultItem.addMatch(new Match("foreignId", "Foreign ID", node.getForeignId()));
            }
            if (QueryUtils.matches((String)node.getForeignSource(), (String)input)) {
                searchResultItem.addMatch(new Match("foreignSource", "Foreign Source", node.getForeignSource()));
            }
            if (QueryUtils.matches((String)node.getLabel(), (String)input)) {
                searchResultItem.addMatch(new Match("label", "Node Label", node.getLabel()));
            }
            searchResultItem.setWeight(100);
            return searchResultItem;
        }).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(Contexts.Node).withMore(totalCount > searchResultItems.size()).withResults(searchResultItems);
        return searchResult;
    }
}

