/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers;

import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.filter.api.FilterParseException;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.providers.SearchResultItemBuilder;
import org.slf4j.LoggerFactory;

public class FilterSearchProvider
implements SearchProvider {
    private final FilterDao filterDao;
    private final NodeDao nodeDao;
    private final EntityScopeProvider entityScopeProvider;

    public FilterSearchProvider(FilterDao filterDao, NodeDao nodeDao, EntityScopeProvider entityScopeProvider) {
        this.filterDao = Objects.requireNonNull(filterDao);
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.entityScopeProvider = Objects.requireNonNull(entityScopeProvider);
    }

    public SearchContext getContext() {
        return Contexts.Node;
    }

    public SearchResult query(SearchQuery query) {
        String input = query.getInput();
        try {
            this.filterDao.validateRule(input);
            SortedMap nodeMap = this.filterDao.getNodeMap(input);
            CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class).in("id", nodeMap.keySet()).orderBy("label").distinct().limit(Integer.valueOf(query.getMaxResults()));
            Criteria criteria = criteriaBuilder.toCriteria();
            List matchingNodes = this.nodeDao.findMatching(criteria);
            List searchResultItems = matchingNodes.stream().map(node -> new SearchResultItemBuilder().withOnmsNode((OnmsNode)node, this.entityScopeProvider).withMatch("filter.criteria", "Filter Criteria", input).build()).collect(Collectors.toList());
            return new SearchResult(Contexts.Node).withResults(searchResultItems).withMore(nodeMap.size() > matchingNodes.size());
        }
        catch (FilterParseException ex) {
            LoggerFactory.getLogger(this.getClass()).debug("Cannot parse expression: {}: {}", (Object)query.getInput(), (Object)ex.getMessage());
            return SearchResult.EMPTY;
        }
    }
}

