/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset.layers;

import java.util.stream.Collectors;
import org.opennms.features.graphml.model.GraphMLNode;
import org.opennms.features.topology.plugins.topo.asset.layers.AssetLayer;
import org.opennms.features.topology.plugins.topo.asset.layers.ItemProvider;
import org.opennms.features.topology.plugins.topo.asset.layers.Layer;
import org.opennms.features.topology.plugins.topo.asset.layers.NodeDecorator;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;

public enum Layers {
    ASSET_COUNTRY(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-country";
        }

        @Override
        public String getLabel() {
            return "Country";
        }

        @Override
        public String getDescription() {
            return "Displays all country fields of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getGeolocation().getCountry();
        }
    }),
    ASSET_ADDRESS1(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-address1";
        }

        @Override
        public String getLabel() {
            return "Address 1";
        }

        @Override
        public String getDescription() {
            return "Displays all address 1 fields of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getGeolocation().getAddress1();
        }
    }),
    ASSET_ADDRESS2(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-address2";
        }

        @Override
        public String getLabel() {
            return "Address 2";
        }

        @Override
        public String getDescription() {
            return "Displays all address 2 fields of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getGeolocation().getAddress2();
        }
    }),
    ASSET_CITY(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-city";
        }

        @Override
        public String getLabel() {
            return "City";
        }

        @Override
        public String getDescription() {
            return "Displays all city fields of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getGeolocation().getCity();
        }
    }),
    ASSET_ZIP(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-zip";
        }

        @Override
        public String getLabel() {
            return "Zip";
        }

        @Override
        public String getDescription() {
            return "Displays all zips of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getGeolocation().getZip();
        }
    }),
    ASSET_STATE(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-state";
        }

        @Override
        public String getLabel() {
            return "State";
        }

        @Override
        public String getDescription() {
            return "Displays all state fields of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getGeolocation().getState();
        }
    }),
    ASSET_LATITUDE(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-latitude";
        }

        @Override
        public String getLabel() {
            return "Latitude";
        }

        @Override
        public String getDescription() {
            return "Displays all latitude fields of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> {
                Double latitude = node.getAssetRecord().getGeolocation().getLatitude();
                return latitude == null ? null : latitude.toString();
            };
        }
    }),
    ASSET_LONGITUDE(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-longitude";
        }

        @Override
        public String getLabel() {
            return "Longitude";
        }

        @Override
        public String getDescription() {
            return "Displays all longitude fields of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> {
                Double longitude = node.getAssetRecord().getGeolocation().getLongitude();
                return longitude == null ? null : longitude.toString();
            };
        }
    }),
    ASSET_BUILDING(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-building";
        }

        @Override
        public String getLabel() {
            return "Building";
        }

        @Override
        public String getDescription() {
            return "Displays all buildings of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getBuilding();
        }
    }),
    ASSET_REGION(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-region";
        }

        @Override
        public String getLabel() {
            return "Region";
        }

        @Override
        public String getDescription() {
            return "Displays all regions of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getRegion();
        }
    }),
    ASSET_DIVISION(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-division";
        }

        @Override
        public String getLabel() {
            return "Division";
        }

        @Override
        public String getDescription() {
            return "Displays all divisions of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getDivision();
        }
    }),
    ASSET_DEPARTMENT(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-department";
        }

        @Override
        public String getLabel() {
            return "Department";
        }

        @Override
        public String getDescription() {
            return "Displays all departments of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getDepartment();
        }
    }),
    ASSET_FLOOR(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-floor";
        }

        @Override
        public String getLabel() {
            return "Floor";
        }

        @Override
        public String getDescription() {
            return "Displays all floors of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getFloor();
        }
    }),
    ASSET_ROOM(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-room";
        }

        @Override
        public String getLabel() {
            return "Room";
        }

        @Override
        public String getDescription() {
            return "Displays all rooms of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getRoom();
        }
    }),
    ASSET_RACK(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-rack";
        }

        @Override
        public String getLabel() {
            return "Rack";
        }

        @Override
        public String getDescription() {
            return "Displays all racks of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getRack();
        }
    }),
    ASSET_SLOT(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-slot";
        }

        @Override
        public String getLabel() {
            return "Slot";
        }

        @Override
        public String getDescription() {
            return "Displays all slots of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getSlot();
        }
    }),
    ASSET_PORT(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-port";
        }

        @Override
        public String getLabel() {
            return "Port";
        }

        @Override
        public String getDescription() {
            return "Displays all ports of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getPort();
        }
    }),
    ASSET_CIRCUIT_ID(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-circuitid";
        }

        @Override
        public String getLabel() {
            return "Circuit ID";
        }

        @Override
        public String getDescription() {
            return "Displays all circuit ids of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getCircuitId();
        }
    }),
    ASSET_CATEGORY(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-category";
        }

        @Override
        public String getLabel() {
            return "Category";
        }

        @Override
        public String getDescription() {
            return "Displays all categories of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getCategory();
        }
    }),
    ASSET_DISPLAY_CATEGORY(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-displaycategory";
        }

        @Override
        public String getLabel() {
            return "Display Category";
        }

        @Override
        public String getDescription() {
            return "Displays all display categories of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getDisplayCategory();
        }
    }),
    ASSET_NOTIFY_CATEGORY(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-notifycategory";
        }

        @Override
        public String getLabel() {
            return "Notify Category";
        }

        @Override
        public String getDescription() {
            return "Displays all notify categories of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getNotifyCategory();
        }
    }),
    ASSET_POLLER_CATEGORY(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-pollercategory";
        }

        @Override
        public String getLabel() {
            return "Poller Category";
        }

        @Override
        public String getDescription() {
            return "Displays all poller categories of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getPollerCategory();
        }
    }),
    ASSET_THRESHOLD_CATEGORY(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-thresholdcategory";
        }

        @Override
        public String getLabel() {
            return "Threshold Category";
        }

        @Override
        public String getDescription() {
            return "Displays all threshold categories of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getThresholdCategory();
        }
    }),
    ASSET_MANAGED_OBJECT_TYPE(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-managedobjecttype";
        }

        @Override
        public String getLabel() {
            return "Managed Object Type";
        }

        @Override
        public String getDescription() {
            return "Displays all managed object types of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getManagedObjectType();
        }
    }),
    ASSET_MANAGED_OBJECT_INSTANCE(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-managedobjectinstance";
        }

        @Override
        public String getLabel() {
            return "Managed Object Instance";
        }

        @Override
        public String getDescription() {
            return "Displays all managed object instances of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getManagedObjectInstance();
        }
    }),
    ASSET_MANUFACTURER(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-manufacturer";
        }

        @Override
        public String getLabel() {
            return "Manufacturer";
        }

        @Override
        public String getDescription() {
            return "Displays all manufacturers of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getManufacturer();
        }
    }),
    ASSET_VENDOR(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-vendor";
        }

        @Override
        public String getLabel() {
            return "Vendor";
        }

        @Override
        public String getDescription() {
            return "Displays all vendors of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getVendor();
        }
    }),
    ASSET_MODEL_NUMBER(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-modelnumber";
        }

        @Override
        public String getLabel() {
            return "Model Number";
        }

        @Override
        public String getDescription() {
            return "Displays all model numbers of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getModelNumber();
        }
    }),
    ASSET_DESCRIPTION(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-description";
        }

        @Override
        public String getLabel() {
            return "Description";
        }

        @Override
        public String getDescription() {
            return "Displays all descriptions of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getDescription();
        }
    }),
    ASSET_OPERATING_SYSTEM(new AssetLayer(){

        @Override
        public String getId() {
            return "asset-operatingsystem";
        }

        @Override
        public String getLabel() {
            return "Operating System";
        }

        @Override
        public String getDescription() {
            return "Displays all operating systems of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getAssetRecord().getOperatingSystem();
        }
    }),
    NODE_LABEL(new AssetLayer(){

        @Override
        public String getId() {
            return "node-nodelabel";
        }

        @Override
        public String getLabel() {
            return "Node Label";
        }

        @Override
        public String getDescription() {
            return "Displays all node labels of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return OnmsNode::getLabel;
        }
    }),
    NODE_ID(new AssetLayer(){

        @Override
        public String getId() {
            return "node-id";
        }

        @Override
        public String getLabel() {
            return "Node ID";
        }

        @Override
        public String getDescription() {
            return "Displays all node ids of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return OnmsNode::getNodeId;
        }
    }),
    NODE_FOREIGN_SOURCE(new AssetLayer(){

        @Override
        public String getId() {
            return "node-foreignsource";
        }

        @Override
        public String getLabel() {
            return "Node Foreign Source";
        }

        @Override
        public String getDescription() {
            return "Displays all node foreign sources of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return OnmsNode::getForeignSource;
        }
    }),
    NODE_FOREIGN_ID(new AssetLayer(){

        @Override
        public String getId() {
            return "node-foreignid";
        }

        @Override
        public String getLabel() {
            return "Node Foreign ID";
        }

        @Override
        public String getDescription() {
            return "Displays all node foreign id of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return OnmsNode::getForeignId;
        }
    }),
    NODE_SYSTEM_NAME(new AssetLayer(){

        @Override
        public String getId() {
            return "node-nodesysname";
        }

        @Override
        public String getLabel() {
            return "Node System Name";
        }

        @Override
        public String getDescription() {
            return "Displays all node system names of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return OnmsNode::getSysName;
        }
    }),
    NODE_SYSTEM_LOCATION(new AssetLayer(){

        @Override
        public String getId() {
            return "node-nodesyslocation";
        }

        @Override
        public String getLabel() {
            return "Node System Location";
        }

        @Override
        public String getDescription() {
            return "Displays all node system locations id of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return OnmsNode::getSysLocation;
        }
    }),
    NODE_OPERATING_SYSTEM(new AssetLayer(){

        @Override
        public String getId() {
            return "node-operatingsystem";
        }

        @Override
        public String getLabel() {
            return "Node Operating System";
        }

        @Override
        public String getDescription() {
            return "Displays all node operating systems of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return OnmsNode::getOperatingSystem;
        }
    }),
    PARENT_NODE_LABEL(new AssetLayer(){

        @Override
        public String getId() {
            return "parent-nodelabel";
        }

        @Override
        public String getLabel() {
            return "Parent Node Label";
        }

        @Override
        public String getDescription() {
            return "Displays all parent node labels of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getParent().getLabel();
        }
    }),
    PARENT_NODE_ID(new AssetLayer(){

        @Override
        public String getId() {
            return "parent-nodeid";
        }

        @Override
        public String getLabel() {
            return "Parent Node ID";
        }

        @Override
        public String getDescription() {
            return "Displays all parent node ids of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getParent().getNodeId();
        }
    }),
    PARENT_FOREIGN_SOURCE(new AssetLayer(){

        @Override
        public String getId() {
            return "parent-foreignsource";
        }

        @Override
        public String getLabel() {
            return "Parent Foreign Source";
        }

        @Override
        public String getDescription() {
            return "Displays all parent foreign sources of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getParent().getForeignSource();
        }
    }),
    PARENT_FOREIGN_ID(new AssetLayer(){

        @Override
        public String getId() {
            return "parent-foreignid";
        }

        @Override
        public String getLabel() {
            return "Parent Foreign ID";
        }

        @Override
        public String getDescription() {
            return "Displays all parent foreign ids of the topology";
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return node -> node.getParent().getForeignId();
        }
    }),
    NODE_CATEGORIES(new AssetLayer(){

        @Override
        public String getId() {
            return "node-categories";
        }

        @Override
        public String getLabel() {
            return "Node Categories";
        }

        @Override
        public String getDescription() {
            return "Displays all node categories of the topology";
        }

        @Override
        public NodeDecorator<String> getNodeDecorator() {
            return new NodeDecorator<String>(){

                @Override
                public void decorate(GraphMLNode graphMLNode, String value) {
                    graphMLNode.setProperty("label", (Object)value);
                }

                @Override
                public String getId(String value) {
                    return value;
                }
            };
        }

        @Override
        public ItemProvider<String> getItemProvider() {
            return new ItemProvider<String>(){

                @Override
                public String getItem(OnmsNode node) {
                    if (node.getCategories().size() == 1) {
                        return ((OnmsCategory)node.getCategories().iterator().next()).getName();
                    }
                    if (node.getCategories().size() > 1) {
                        return node.getCategories().stream().map(c -> c.getName()).collect(Collectors.joining(","));
                    }
                    return null;
                }
            };
        }
    });

    private final Layer layer;

    private Layers(Layer layer) {
        this.layer = layer;
    }

    public Layer getLayer() {
        return this.layer;
    }
}

