/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset.filter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.opennms.features.topology.plugins.topo.asset.filter.EqCsvFilter;
import org.opennms.features.topology.plugins.topo.asset.filter.Filter;
import org.opennms.features.topology.plugins.topo.asset.filter.NotFilter;
import org.opennms.features.topology.plugins.topo.asset.filter.OrFilter;
import org.opennms.features.topology.plugins.topo.asset.filter.RegExCsvFilter;
import org.opennms.features.topology.plugins.topo.asset.layers.NodeParamLabels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterParser {
    private static final Logger LOG = LoggerFactory.getLogger(FilterParser.class);

    public Map<String, Filter> parse(List<String> filter) {
        LinkedHashMap<String, Filter> filterMap = new LinkedHashMap<String, Filter>();
        LinkedHashMap filterStringMap = new LinkedHashMap();
        if (filter == null) {
            return filterMap;
        }
        for (String s : filter) {
            String[] values;
            String[] x = s.split("=");
            if (x.length < 2) {
                throw new IllegalArgumentException("Cannot parse filter. no '=' in expression:" + s);
            }
            if (x.length > 2) {
                throw new IllegalArgumentException("Cannot parse filter. too many '=' in expression:" + s);
            }
            String nodeParamLabel = x[0];
            String filterValue = x[1];
            if (!NodeParamLabels.ALL_KEYS.contains(nodeParamLabel)) {
                throw new IllegalArgumentException("Cannot parse filter. Unknown nodeParamLabel value '" + nodeParamLabel + "' in expression:" + s);
            }
            if (!filterStringMap.containsKey(nodeParamLabel)) {
                filterStringMap.put(nodeParamLabel, new ArrayList());
            }
            for (String value : values = filterValue.split(",")) {
                if ("".equals(value)) {
                    throw new IllegalArgumentException("Cannot parse filter. Cannot have empty value '" + value + "' in expression:" + s);
                }
                ((List)filterStringMap.get(nodeParamLabel)).add(value);
            }
        }
        for (String nodeParamLabel : filterStringMap.keySet()) {
            ArrayList includeFilters = new ArrayList();
            ArrayList excludeFilters = new ArrayList();
            for (String filterValueString : (List)filterStringMap.get(nodeParamLabel)) {
                String valStr = null;
                String regexStr = null;
                Filter<String> f = null;
                if (filterValueString.startsWith("!")) {
                    if (filterValueString.startsWith("!~")) {
                        regexStr = filterValueString.substring(2);
                        try {
                            f = new RegExCsvFilter(regexStr);
                        }
                        catch (PatternSyntaxException syntaxException) {
                            throw new IllegalArgumentException("Cannot parse filter. Illegal Regex expression for '" + nodeParamLabel + "' value in expression:" + filterValueString, syntaxException);
                        }
                    } else {
                        valStr = filterValueString.substring(1);
                        f = new EqCsvFilter<String>(valStr);
                    }
                    excludeFilters.add(f);
                } else {
                    if (filterValueString.startsWith("~")) {
                        regexStr = filterValueString.substring(1);
                        try {
                            f = new RegExCsvFilter(regexStr);
                        }
                        catch (PatternSyntaxException syntaxException) {
                            throw new IllegalArgumentException("Cannot parse filter. Illegal Regex expression for '" + nodeParamLabel + "' value in expression:" + filterValueString, syntaxException);
                        }
                    } else {
                        valStr = filterValueString;
                        f = new EqCsvFilter<String>(valStr);
                    }
                    includeFilters.add(f);
                }
                if (valStr != null) {
                    if (valStr.contains("~")) {
                        throw new IllegalArgumentException("Cannot parse filter. Illegal '~' character for '" + nodeParamLabel + "' value in expression:" + filterValueString);
                    }
                    if (valStr.contains("!")) {
                        throw new IllegalArgumentException("Cannot parse filter. Illegal '!' character for '" + nodeParamLabel + "' value in expression:" + filterValueString);
                    }
                    if (valStr.equals("")) {
                        throw new IllegalArgumentException("Cannot parse filter. Illegal empty value for '" + nodeParamLabel + "' value in expression:" + filterValueString);
                    }
                }
                if (regexStr == null) continue;
                if (regexStr.contains("~")) {
                    throw new IllegalArgumentException("Cannot parse filter. Illegal '~' character for '" + nodeParamLabel + "' value in expression:" + filterValueString);
                }
                if (!regexStr.equals("")) continue;
                throw new IllegalArgumentException("Cannot parse filter. Illegal empty value for '" + nodeParamLabel + "' value in expression:" + filterValueString);
            }
            OrFilter topFilter = includeFilters.isEmpty() ? new OrFilter(excludeFilters) : new OrFilter(new NotFilter(new OrFilter(includeFilters)), new OrFilter(excludeFilters));
            filterMap.put(nodeParamLabel, topFilter);
        }
        return filterMap;
    }
}

