/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import org.opennms.features.topology.api.support.breadcrumbs.BreadcrumbStrategy;

@XmlAccessorType(value=XmlAccessType.NONE)
public class GeneratorConfig {
    @XmlElement(name="label")
    private String label = "Asset Topology Provider";
    @XmlElement(name="breadcrumb-strategy")
    private String breadcrumbStrategy = BreadcrumbStrategy.SHORTEST_PATH_TO_ROOT.name();
    @XmlID
    @XmlElement(name="provider-id")
    private String providerId = "asset";
    @XmlElement(name="preferred-layout")
    private String preferredLayout = "Grid Layout";
    @XmlElement(name="filter")
    @XmlElementWrapper(name="filters")
    private List<String> filters = new ArrayList<String>();
    @XmlElementWrapper(name="layers")
    @XmlElement(name="layer")
    private List<String> layerHierarchies = new ArrayList<String>();

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getBreadcrumbStrategy() {
        return this.breadcrumbStrategy;
    }

    public void setBreadcrumbStrategy(String breadcrumbStrategy) {
        this.breadcrumbStrategy = breadcrumbStrategy;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getPreferredLayout() {
        return this.preferredLayout;
    }

    public void setPreferredLayout(String preferredLayout) {
        this.preferredLayout = preferredLayout;
    }

    public List<String> getLayerHierarchies() {
        return this.layerHierarchies;
    }

    public void setLayerHierarchies(List<String> layers) {
        if (layers == this.layerHierarchies) {
            return;
        }
        this.layerHierarchies.clear();
        if (layers != null) {
            this.layerHierarchies.addAll(layers);
        }
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        if (filters == this.filters) {
            return;
        }
        this.filters.clear();
        if (filters != null) {
            this.filters.addAll(filters);
        }
    }

    public int hashCode() {
        return Objects.hash(this.label, this.breadcrumbStrategy, this.providerId, this.filters, this.preferredLayout, this.layerHierarchies);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof GeneratorConfig) {
            GeneratorConfig other = (GeneratorConfig)obj;
            return Objects.equals(this.label, other.label) && Objects.equals(this.breadcrumbStrategy, other.breadcrumbStrategy) && Objects.equals(this.providerId, other.providerId) && Objects.equals(this.filters, other.filters) && Objects.equals(this.preferredLayout, other.preferredLayout) && Objects.equals(this.layerHierarchies, other.layerHierarchies);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("providerId", (Object)this.providerId).add("label", (Object)this.label).add("layerHierarchies", this.layerHierarchies).add("filters", this.filters).add("breadcrumbStrategy", (Object)this.breadcrumbStrategy).add("preferredLayout", (Object)this.preferredLayout).toString();
    }
}

