/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.monitors;

import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigDao;
import org.opennms.features.deviceconfig.retrieval.api.Retriever;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.poller.DeviceConfig;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceConfigMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceConfigMonitor.class);
    public static final String SCRIPT = "script";
    public static final String USERNAME = "username";
    public static final String SSH_PORT = "ssh-port";
    public static final String SSH_TIMEOUT = "ssh-timeout";
    public static final String PASSWORD = "password";
    public static final String AUTH_KEY = "auth-key";
    public static final String HOST_KEY = "host-key";
    public static final String LAST_RETRIEVAL = "lastRetrieval";
    public static final String SCRIPT_FILE = "script-file";
    private static final String SCRIPT_ERROR = "script-error";
    public static final String SHELL = "shell";
    private static final Duration DEFAULT_DURATION = Duration.ofMinutes(1L);
    private static final int DEFAULT_SSH_PORT = 22;
    private Retriever retriever;
    private IpInterfaceDao ipInterfaceDao;
    private DeviceConfigDao deviceConfigDao;
    private SessionUtils sessionUtils;

    public Map<String, Object> getRuntimeAttributes(MonitoredService svc, Map<String, Object> parameters) {
        return (Map)this.sessionUtils.withReadOnlyTransaction(() -> {
            HashMap<String, String> params = new HashMap<String, String>();
            OnmsIpInterface ipInterface = this.ipInterfaceDao.findByNodeIdAndIpAddress(Integer.valueOf(svc.getNodeId()), svc.getIpAddr());
            params.put(LAST_RETRIEVAL, Long.toString(this.deviceConfigDao.getLatestConfigForInterface(ipInterface, svc.getSvcName()).map(org.opennms.features.deviceconfig.persistence.api.DeviceConfig::getLastUpdated).orElse(ipInterface.getNode().getCreateTime()).getTime()));
            String scriptFile = DeviceConfigMonitor.getKeyedString((Map)parameters, (String)SCRIPT_FILE, null);
            try {
                if (scriptFile != null) {
                    String script = DeviceConfigMonitor.parseScriptFile(scriptFile);
                    params.put(SCRIPT, script);
                }
            }
            catch (Exception e) {
                LOG.error("Error while parsing script file {}", (Object)scriptFile, (Object)e);
                params.put(SCRIPT_ERROR, e.getMessage());
            }
            return params;
        });
    }

    private static String parseScriptFile(String fileName) throws IOException {
        String opennmsHome = ConfigFileConstants.getHome();
        Path script = Paths.get(opennmsHome, "etc", "device-config", fileName);
        if (script.toFile().exists()) {
            return Files.readString(script);
        }
        throw new FileNotFoundException("Couldn't find file " + fileName + " in etc/device-config folder");
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        boolean triggeredPoll = Boolean.parseBoolean(DeviceConfigMonitor.getKeyedString(parameters, (String)"dcbTriggeredPoll", (String)"false"));
        Date lastRun = new Date(DeviceConfigMonitor.getKeyedLong(parameters, (String)LAST_RETRIEVAL, (Long)0L));
        String cronSchedule = DeviceConfigMonitor.getKeyedString(parameters, (String)"schedule", (String)"0 0 0 * * ?");
        if (!triggeredPoll) {
            if (Strings.isNullOrEmpty((String)cronSchedule) || "never".equalsIgnoreCase(cronSchedule)) {
                return PollStatus.unknown((String)"Not scheduled");
            }
            try {
                Date nextRun = this.getNextRunDate(cronSchedule, lastRun);
                if (!nextRun.before(new Date())) {
                    return PollStatus.unknown((String)("Skipping. Next retrieval scheduled for " + String.valueOf(nextRun)));
                }
            }
            catch (Exception e2) {
                LOG.error("Exception in parsing cron expression {}", (Object)cronSchedule, (Object)e2);
                return PollStatus.down((String)("Invalid cron expression : " + cronSchedule));
            }
        }
        if (parameters.containsKey(SCRIPT_ERROR)) {
            String reason = this.getObjectAsStringFromParams(parameters, SCRIPT_ERROR);
            PollStatus status = PollStatus.unavailable((String)reason);
            status.setDeviceConfig(new DeviceConfig());
            return status;
        }
        parameters.put("backupStartTime", System.currentTimeMillis());
        parameters.put("backupDataProtocol", Retriever.Protocol.TFTP);
        String script = this.getObjectAsStringFromParams(parameters, SCRIPT);
        String user = this.getObjectAsStringFromParams(parameters, USERNAME);
        String password = this.getObjectAsStringFromParams(parameters, PASSWORD);
        String authKey = this.getObjectAsStringFromParams(parameters, AUTH_KEY);
        Integer port = DeviceConfigMonitor.getKeyedInteger(parameters, (String)SSH_PORT, (Integer)22);
        String configType = DeviceConfigMonitor.getKeyedString(parameters, (String)"config-type", (String)"default");
        Long timeout = DeviceConfigMonitor.getKeyedLong(parameters, (String)SSH_TIMEOUT, (Long)DEFAULT_DURATION.toMillis());
        String hostKeyFingerprint = DeviceConfigMonitor.getKeyedString(parameters, (String)HOST_KEY, null);
        Map<String, String> stringParameters = parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
        String shell = DeviceConfigMonitor.getKeyedString(parameters, (String)SHELL, null);
        InetSocketAddress target = new InetSocketAddress(svc.getAddress(), (int)port);
        CompletionStage<PollStatus> future = this.retriever.retrieveConfig(Retriever.Protocol.TFTP, script, user, password, authKey, (SocketAddress)target, hostKeyFingerprint, shell, configType, stringParameters, Duration.ofMillis(timeout).minusSeconds(1L)).thenApply(either -> (PollStatus)either.fold(failure -> {
            LOG.error("Device config retrieval could not be triggered - target: {}; script: {};  message: {} \nstdout: {}\nstderr: {}", new Object[]{target, script, failure.message, failure.stdout, failure.stderr});
            PollStatus pollStatus = PollStatus.unavailable((String)failure.message);
            pollStatus.setDeviceConfig(new DeviceConfig(failure.scriptOutput));
            return pollStatus;
        }, success -> {
            LOG.debug("Retrieved device configuration - target: " + String.valueOf(target));
            PollStatus pollStatus = PollStatus.up();
            pollStatus.setDeviceConfig(new DeviceConfig(success.config, success.filename, success.scriptOutput));
            return pollStatus;
        }));
        try {
            LOG.debug("Starting retrieval, waiting at most {} milliseconds", (Object)timeout);
            return future.toCompletableFuture().get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e3) {
            LOG.error("Device config retrieval failed - target: " + String.valueOf(target), (Throwable)e3);
            PollStatus pollStatus = PollStatus.unavailable((String)("Device config retrieval failed - target: " + String.valueOf(target) + "; message: " + e3.getMessage()));
            pollStatus.setDeviceConfig(new DeviceConfig());
            return pollStatus;
        }
    }

    public void setRetriever(Retriever retriever) {
        this.retriever = retriever;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.ipInterfaceDao = ipInterfaceDao;
    }

    public void setDeviceConfigDao(DeviceConfigDao deviceConfigDao) {
        this.deviceConfigDao = deviceConfigDao;
    }

    public void setSessionUtils(SessionUtils sessionUtils) {
        this.sessionUtils = sessionUtils;
    }

    private Date getNextRunDate(String cronSchedule, Date lastRun) {
        Trigger trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronSchedule)).startAt(lastRun).build();
        return trigger.getFireTimeAfter(lastRun);
    }

    private String getObjectAsStringFromParams(Map<String, Object> params, String key) {
        Object obj = params.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new IllegalArgumentException(key + " is not an instance of String");
    }
}

