/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.connection;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.opennms.core.utils.AnyServerX509TrustManager;
import org.opennms.netmgt.jmx.connection.JmxConnectionConfig;
import org.slf4j.LoggerFactory;

public interface PasswordStrategy {
    public static final PasswordStrategy PASSWORD_CLEAR = (env, config) -> {
        if (config.hasCredentials()) {
            env.put("jmx.remote.credentials", config.getCredentials());
        }
    };
    public static final PasswordStrategy SASL = (env, config) -> {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            AnyServerX509TrustManager tm = new AnyServerX509TrustManager();
            SSLContext ctx = SSLContext.getInstance("TLSv1");
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = ctx.getSocketFactory();
            env.put("jmx.remote.tls.socket.factory", ssf);
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
        env.put("jmx.remote.profiles", "TLS SASL/PLAIN");
        if (config.hasCredentials()) {
            String[] creds = config.getCredentials();
            env.put("jmx.remote.credentials", creds);
        }
    };
    public static final PasswordStrategy STANDARD = (env, config) -> {
        if (config.hasCredentials()) {
            LoggerFactory.getLogger(PasswordStrategy.class).warn("PasswordStrategy is STANDARD but credentials are provided. Using PASSWORD_CLEAR instead.");
            PASSWORD_CLEAR.apply(env, config);
        }
    };

    public void apply(Map<String, Object> var1, JmxConnectionConfig var2);
}

