/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import jcifs.Configuration;
import jcifs.RuntimeCIFSException;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Strings {
    private static final Logger log = LoggerFactory.getLogger(Strings.class);
    private static final Charset UNI_ENCODING = Charset.forName("UTF-16LE");
    private static final Charset ASCII_ENCODING = Charset.forName("US-ASCII");

    private Strings() {
    }

    public static byte[] getBytes(String str, Charset encoding) {
        if (str == null) {
            return new byte[0];
        }
        return str.getBytes(encoding);
    }

    public static byte[] getUNIBytes(String str) {
        return Strings.getBytes(str, UNI_ENCODING);
    }

    public static byte[] getASCIIBytes(String str) {
        return Strings.getBytes(str, ASCII_ENCODING);
    }

    public static byte[] getOEMBytes(String str, Configuration config) {
        if (str == null) {
            return new byte[0];
        }
        try {
            return str.getBytes(config.getOemEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeCIFSException("Unsupported OEM encoding " + config.getOemEncoding(), e);
        }
    }

    public static String fromUNIBytes(byte[] src, int srcIndex, int len) {
        return new String(src, srcIndex, len, UNI_ENCODING);
    }

    public static int findUNITermination(byte[] buffer, int bufferIndex, int maxLen) {
        int len = 0;
        while (buffer[bufferIndex + len] != 0 || buffer[bufferIndex + len + 1] != 0) {
            if ((len += 2) <= maxLen) continue;
            if (log.isDebugEnabled()) {
                log.warn("Failed to find string termination with max length " + maxLen);
                log.debug(Hexdump.toHexString(buffer, bufferIndex, len));
            }
            throw new RuntimeCIFSException("zero termination not found");
        }
        return len;
    }

    public static String fromOEMBytes(byte[] src, int srcIndex, int len, Configuration config) {
        try {
            return new String(src, srcIndex, len, config.getOemEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeCIFSException("Unsupported OEM encoding " + config.getOemEncoding(), e);
        }
    }

    public static int findTermination(byte[] buffer, int bufferIndex, int maxLen) {
        int len = 0;
        while (buffer[bufferIndex + len] != 0) {
            if (++len <= maxLen) continue;
            throw new RuntimeCIFSException("zero termination not found");
        }
        return len;
    }
}

