/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.SidResolver;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.UnicodeString;
import jcifs.dcerpc.msrpc.LsaPolicyHandle;
import jcifs.dcerpc.msrpc.MsrpcLookupSids;
import jcifs.dcerpc.msrpc.MsrpcQueryInformationPolicy;
import jcifs.dcerpc.msrpc.lsarpc;
import jcifs.dcerpc.ndr.NdrObject;
import jcifs.dcerpc.rpc;
import jcifs.smb.SID;
import jcifs.smb.SmbException;

public class SIDCacheImpl
implements SidResolver {
    private Map<SID, SID> sidCache = new HashMap<SID, SID>();

    public SIDCacheImpl(CIFSContext baseContext) {
    }

    void resolveSids(DcerpcHandle handle, LsaPolicyHandle policyHandle, jcifs.SID[] sids) throws IOException {
        MsrpcLookupSids rpc2 = new MsrpcLookupSids(policyHandle, sids);
        handle.sendrecv(rpc2);
        switch (rpc2.retval) {
            case -1073741709: 
            case 0: 
            case 263: {
                break;
            }
            default: {
                throw new SmbException(rpc2.retval, false);
            }
        }
        for (int si = 0; si < sids.length; ++si) {
            SID out = sids[si].unwrap(SID.class);
            lsarpc.LsarTranslatedName resp = rpc2.names.names[si];
            out.domainName = null;
            switch (resp.sid_type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    rpc.unicode_string ustr = rpc2.domains.domains[resp.sid_index].name;
                    out.domainName = new UnicodeString(ustr, false).toString();
                }
            }
            UnicodeString ucstr = new UnicodeString(resp.name, false);
            out.acctName = ucstr.toString();
            out.type = resp.sid_type;
            out.origin_server = null;
            out.origin_ctx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveSids0(String authorityServerName, CIFSContext tc, jcifs.SID[] sids) throws CIFSException {
        Map<SID, SID> map = this.sidCache;
        synchronized (map) {
            try (DcerpcHandle handle = DcerpcHandle.getHandle("ncacn_np:" + authorityServerName + "[\\PIPE\\lsarpc]", tc);){
                String server = authorityServerName;
                int dot = server.indexOf(46);
                if (dot > 0 && !Character.isDigit(server.charAt(0))) {
                    server = server.substring(0, dot);
                }
                try (LsaPolicyHandle policyHandle = new LsaPolicyHandle(handle, "\\\\" + server, 2048);){
                    this.resolveSids(handle, policyHandle, sids);
                }
            }
            catch (IOException e) {
                throw new CIFSException("Failed to resolve SIDs", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveSids(CIFSContext tc, String authorityServerName, jcifs.SID[] sids, int offset, int length) throws CIFSException {
        ArrayList<SID> list = new ArrayList<SID>(sids.length);
        Map<SID, SID> map = this.sidCache;
        synchronized (map) {
            int si;
            for (si = 0; si < length; ++si) {
                SID s = sids[offset + si].unwrap(SID.class);
                SID sid = this.sidCache.get(s);
                if (sid != null) {
                    s.type = sid.type;
                    s.domainName = sid.domainName;
                    s.acctName = sid.acctName;
                    continue;
                }
                list.add(s);
            }
            if (list.size() > 0) {
                jcifs.SID[] resolved = list.toArray(new SID[list.size()]);
                this.resolveSids0(authorityServerName, tc, resolved);
                for (si = 0; si < resolved.length; ++si) {
                    this.sidCache.put((SID)resolved[si], (SID)resolved[si]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveSids(CIFSContext tc, String authorityServerName, jcifs.SID[] sids) throws CIFSException {
        ArrayList<SID> list = new ArrayList<SID>(sids.length);
        Map<SID, SID> map = this.sidCache;
        synchronized (map) {
            int si;
            for (si = 0; si < sids.length; ++si) {
                SID s = sids[si].unwrap(SID.class);
                SID sid = this.sidCache.get(s);
                if (sid != null) {
                    s.type = sid.type;
                    s.domainName = sid.domainName;
                    s.acctName = sid.acctName;
                    continue;
                }
                list.add(s);
            }
            if (list.size() > 0) {
                jcifs.SID[] resolved = list.toArray(new SID[list.size()]);
                this.resolveSids0(authorityServerName, tc, resolved);
                for (si = 0; si < resolved.length; ++si) {
                    this.sidCache.put((SID)resolved[si], (SID)resolved[si]);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SID getServerSid(CIFSContext tc, String server) throws CIFSException {
        lsarpc.LsarDomainInfo info = new lsarpc.LsarDomainInfo();
        Map<SID, SID> map = this.sidCache;
        synchronized (map) {
            try (DcerpcHandle handle = DcerpcHandle.getHandle("ncacn_np:" + server + "[\\PIPE\\lsarpc]", tc);){
                try (LsaPolicyHandle policyHandle = new LsaPolicyHandle(handle, null, 1);){
                    MsrpcQueryInformationPolicy rpc2 = new MsrpcQueryInformationPolicy(policyHandle, 5, (NdrObject)info);
                    handle.sendrecv(rpc2);
                    if (rpc2.retval != 0) {
                        throw new SmbException(rpc2.retval, false);
                    }
                }
                SID sID = new SID(info.sid, 3, new UnicodeString(info.name, false).toString(), null, false);
                return sID;
            }
            catch (IOException e) {
                throw new CIFSException("Failed to get SID from server", e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public SID[] getGroupMemberSids(CIFSContext tc, String authorityServerName, jcifs.SID domsid, int rid, int flags) throws CIFSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<jcifs.SID, List<jcifs.SID>> getLocalGroupsMap(CIFSContext tc, String authorityServerName, int flags) throws CIFSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

