/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.trans.nt;

import jcifs.Configuration;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.smb1.trans.SmbComTransaction;
import jcifs.internal.smb1.trans.nt.SmbComNtCancel;
import jcifs.internal.util.SMBUtil;

public abstract class SmbComNtTransaction
extends SmbComTransaction {
    private static final int NTT_PRIMARY_SETUP_OFFSET = 71;
    private static final int NTT_SECONDARY_PARAMETER_OFFSET = 51;
    public static final int NT_TRANSACT_QUERY_SECURITY_DESC = 6;
    public static final int NT_TRANSACT_NOTIFY_CHANGE = 4;
    private final int function;

    protected SmbComNtTransaction(Configuration config, int function) {
        super(config, (byte)-96, (byte)0);
        this.function = function;
        this.primarySetupOffset = 71;
        this.secondaryParameterOffset = 51;
    }

    @Override
    public CommonServerMessageBlockRequest createCancel() {
        return new SmbComNtCancel(this.getConfig(), (int)this.getMid());
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex++] = this.getCommand() != -95 ? this.maxSetupCount : (byte)0;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        SMBUtil.writeInt4(this.totalParameterCount, dst, dstIndex);
        SMBUtil.writeInt4(this.totalDataCount, dst, dstIndex += 4);
        dstIndex += 4;
        if (this.getCommand() != -95) {
            SMBUtil.writeInt4(this.maxParameterCount, dst, dstIndex);
            SMBUtil.writeInt4(this.maxDataCount, dst, dstIndex += 4);
            dstIndex += 4;
        }
        SMBUtil.writeInt4(this.parameterCount, dst, dstIndex);
        SMBUtil.writeInt4(this.parameterCount == 0 ? 0 : this.parameterOffset, dst, dstIndex += 4);
        dstIndex += 4;
        if (this.getCommand() == -95) {
            SMBUtil.writeInt4(this.parameterDisplacement, dst, dstIndex);
            dstIndex += 4;
        }
        SMBUtil.writeInt4(this.dataCount, dst, dstIndex);
        SMBUtil.writeInt4(this.dataCount == 0 ? 0 : this.dataOffset, dst, dstIndex += 4);
        dstIndex += 4;
        if (this.getCommand() == -95) {
            SMBUtil.writeInt4(this.dataDisplacement, dst, dstIndex);
            dstIndex += 4;
            dst[dstIndex++] = 0;
        } else {
            dst[dstIndex++] = (byte)this.setupCount;
            SMBUtil.writeInt2(this.function, dst, dstIndex);
            dstIndex += 2;
            dstIndex += this.writeSetupWireFormat(dst, dstIndex);
        }
        return dstIndex - start;
    }
}

