/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.siteStatusViews;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.siteStatusViews.RowDef;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="view")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="site-status-views.xsd")
public class View
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_TABLE_NAME = "assets";
    private static final String DEFAULT_COLUMN_NAME = "building";
    private static final String DEFAULT_COLUMN_TYPE = "varchar";
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="table-name")
    private String m_tableName;
    @XmlAttribute(name="column-name")
    private String m_columnName;
    @XmlAttribute(name="column-type")
    private String m_columnType;
    @XmlAttribute(name="column-value")
    private String m_columnValue;
    @XmlElementWrapper(name="rows", required=true)
    @XmlElement(name="row-def", required=true)
    private List<RowDef> m_rows = new ArrayList<RowDef>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getTableName() {
        return this.m_tableName != null ? this.m_tableName : DEFAULT_TABLE_NAME;
    }

    public void setTableName(String tableName) {
        this.m_tableName = ConfigUtils.normalizeString(tableName);
    }

    public String getColumnName() {
        return this.m_columnName != null ? this.m_columnName : DEFAULT_COLUMN_NAME;
    }

    public void setColumnName(String columnName) {
        this.m_columnName = ConfigUtils.normalizeString(columnName);
    }

    public String getColumnType() {
        return this.m_columnType != null ? this.m_columnType : DEFAULT_COLUMN_TYPE;
    }

    public void setColumnType(String columnType) {
        this.m_columnType = ConfigUtils.normalizeString(columnType);
    }

    public Optional<String> getColumnValue() {
        return Optional.ofNullable(this.m_columnValue);
    }

    public void setColumnValue(String columnValue) {
        this.m_columnValue = ConfigUtils.normalizeString(columnValue);
    }

    public List<RowDef> getRows() {
        return this.m_rows;
    }

    public void setRows(List<RowDef> rows) {
        if (rows == this.m_rows) {
            return;
        }
        this.m_rows.clear();
        if (rows != null) {
            this.m_rows.addAll(rows);
        }
    }

    public void addRow(RowDef row) {
        this.m_rows.add(row);
    }

    public void addRow(String rowLabel, String ... categories) {
        this.m_rows.add(new RowDef(rowLabel, categories));
    }

    public boolean removeRow(RowDef row) {
        return this.m_rows.remove(row);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_tableName, this.m_columnName, this.m_columnType, this.m_columnValue, this.m_rows);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof View) {
            View that = (View)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_tableName, that.m_tableName) && Objects.equals(this.m_columnName, that.m_columnName) && Objects.equals(this.m_columnType, that.m_columnType) && Objects.equals(this.m_columnValue, that.m_columnValue) && Objects.equals(this.m_rows, that.m_rows);
        }
        return false;
    }
}

