/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.scriptd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.scriptd.Engine;
import org.opennms.netmgt.config.scriptd.EventScript;
import org.opennms.netmgt.config.scriptd.ReloadScript;
import org.opennms.netmgt.config.scriptd.StartScript;
import org.opennms.netmgt.config.scriptd.StopScript;

@XmlRootElement(name="scriptd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="scriptd-configuration.xsd")
public class ScriptdConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="engine")
    private List<Engine> m_engines = new ArrayList<Engine>();
    @XmlElement(name="start-script")
    private List<StartScript> m_startScripts = new ArrayList<StartScript>();
    @XmlElement(name="stop-script")
    private List<StopScript> m_stopScripts = new ArrayList<StopScript>();
    @XmlElement(name="reload-script")
    private List<ReloadScript> m_reloadScripts = new ArrayList<ReloadScript>();
    @XmlElement(name="event-script")
    private List<EventScript> m_eventScripts = new ArrayList<EventScript>();
    @XmlAttribute(name="transactional")
    private Boolean m_transactional;

    public List<Engine> getEngines() {
        return this.m_engines;
    }

    public void setEngines(List<Engine> engines) {
        if (engines == this.m_engines) {
            return;
        }
        this.m_engines.clear();
        if (engines != null) {
            this.m_engines.addAll(engines);
        }
    }

    public void addEngine(Engine engine) {
        this.m_engines.add(engine);
    }

    public boolean removeEngine(Engine engine) {
        return this.m_engines.remove(engine);
    }

    public List<StartScript> getStartScripts() {
        return this.m_startScripts;
    }

    public void setStartScripts(List<StartScript> startScripts) {
        if (startScripts == this.m_startScripts) {
            return;
        }
        this.m_startScripts.clear();
        if (startScripts != null) {
            this.m_startScripts.addAll(startScripts);
        }
    }

    public void addStartScript(StartScript startScript) {
        this.m_startScripts.add(startScript);
    }

    public boolean removeStartScript(StartScript startScript) {
        return this.m_startScripts.remove(startScript);
    }

    public List<StopScript> getStopScripts() {
        return this.m_stopScripts;
    }

    public void setStopScripts(List<StopScript> stopScripts) {
        if (stopScripts == this.m_stopScripts) {
            return;
        }
        this.m_stopScripts.clear();
        if (stopScripts != null) {
            this.m_stopScripts.addAll(stopScripts);
        }
    }

    public void addStopScript(StopScript stopScript) {
        this.m_stopScripts.add(stopScript);
    }

    public boolean removeStopScript(StopScript stopScript) {
        return this.m_stopScripts.remove(stopScript);
    }

    public List<ReloadScript> getReloadScripts() {
        return this.m_reloadScripts;
    }

    public void setReloadScripts(List<ReloadScript> reloadScripts) {
        if (reloadScripts == this.m_reloadScripts) {
            return;
        }
        this.m_reloadScripts.clear();
        if (reloadScripts != null) {
            this.m_reloadScripts.addAll(reloadScripts);
        }
    }

    public void addReloadScript(ReloadScript reloadScript) {
        this.m_reloadScripts.add(reloadScript);
    }

    public boolean removeReloadScript(ReloadScript reloadScript) {
        return this.m_reloadScripts.remove(reloadScript);
    }

    public List<EventScript> getEventScripts() {
        return this.m_eventScripts;
    }

    public void setEventScripts(List<EventScript> eventScripts) {
        if (eventScripts == this.m_eventScripts) {
            return;
        }
        this.m_eventScripts.clear();
        if (eventScripts != null) {
            this.m_eventScripts.addAll(eventScripts);
        }
    }

    public void addEventScript(EventScript eventScript) {
        this.m_eventScripts.add(eventScript);
    }

    public boolean removeEventScript(EventScript eventScript) {
        return this.m_eventScripts.remove(eventScript);
    }

    public Boolean getTransactional() {
        return this.m_transactional != null ? this.m_transactional : Boolean.TRUE;
    }

    public void setTransactional(Boolean transactional) {
        this.m_transactional = transactional;
    }

    public int hashCode() {
        return Objects.hash(this.m_engines, this.m_startScripts, this.m_stopScripts, this.m_reloadScripts, this.m_eventScripts, this.m_transactional);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ScriptdConfiguration) {
            ScriptdConfiguration that = (ScriptdConfiguration)obj;
            return Objects.equals(this.m_engines, that.m_engines) && Objects.equals(this.m_startScripts, that.m_startScripts) && Objects.equals(this.m_stopScripts, that.m_stopScripts) && Objects.equals(this.m_reloadScripts, that.m_reloadScripts) && Objects.equals(this.m_eventScripts, that.m_eventScripts) && Objects.equals(this.m_transactional, that.m_transactional);
        }
        return false;
    }
}

