/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.httpdatacollection;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.httpdatacollection.Parameter;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"m_parameters"})
@XmlRootElement(name="url")
@ValidateUsing(value="http-datacollection-config.xsd")
public class Url
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    protected List<Parameter> m_parameters;
    @XmlAttribute(name="method")
    protected String m_method;
    @XmlAttribute(name="http-version")
    protected String m_httpVersion;
    @XmlAttribute(name="user-agent")
    protected String m_userAgent;
    @XmlAttribute(name="virtual-host")
    protected String m_virtualHost;
    @XmlAttribute(name="scheme")
    protected String m_scheme;
    @XmlAttribute(name="user-info")
    protected String m_userInfo;
    @XmlAttribute(name="host")
    protected String m_host;
    @XmlAttribute(name="port")
    protected Integer m_port;
    @XmlAttribute(name="path", required=true)
    protected String m_path;
    @XmlAttribute(name="query")
    protected String m_query;
    @XmlAttribute(name="fragment")
    protected String m_fragment;
    @XmlAttribute(name="matches")
    protected String m_matches;
    @XmlAttribute(name="response-range")
    protected String m_responseRange;
    @XmlAttribute(name="canonical-equivalence")
    protected Boolean m_canonicalEquivalence;
    @XmlAttribute(name="case-insensitive")
    protected Boolean m_caseInsensitive;
    @XmlAttribute(name="comments")
    protected Boolean m_comments;
    @XmlAttribute(name="dotall")
    protected Boolean m_dotall;
    @XmlAttribute(name="literal")
    protected Boolean m_literal;
    @XmlAttribute(name="multiline")
    protected Boolean m_multiline;
    @XmlAttribute(name="unicode-case")
    protected Boolean m_unicodeCase;
    @XmlAttribute(name="unix-lines")
    protected Boolean m_unixLines;

    public List<Parameter> getParameters() {
        return this.m_parameters == null ? Collections.emptyList() : this.m_parameters;
    }

    public void setParameters(List<Parameter> value) {
        this.m_parameters = value;
    }

    public String getMethod() {
        return this.m_method == null ? "GET" : this.m_method;
    }

    public void setMethod(String value) {
        this.m_method = ConfigUtils.normalizeString(value);
    }

    public String getHttpVersion() {
        return this.m_httpVersion == null ? "1.1" : this.m_httpVersion;
    }

    public void setHttpVersion(String value) {
        this.m_httpVersion = ConfigUtils.normalizeString(value);
    }

    public Optional<String> getUserAgent() {
        return Optional.ofNullable(this.m_userAgent);
    }

    public void setUserAgent(String value) {
        this.m_userAgent = ConfigUtils.normalizeString(value);
    }

    public Optional<String> getVirtualHost() {
        return Optional.ofNullable(this.m_virtualHost);
    }

    public void setVirtualHost(String value) {
        this.m_virtualHost = ConfigUtils.normalizeString(value);
    }

    public String getScheme() {
        return this.m_scheme == null ? "http" : this.m_scheme;
    }

    public void setScheme(String value) {
        this.m_scheme = ConfigUtils.normalizeString(value);
    }

    public Optional<String> getUserInfo() {
        return Optional.ofNullable(this.m_userInfo);
    }

    public void setUserInfo(String value) {
        this.m_userInfo = ConfigUtils.normalizeString(value);
    }

    public String getHost() {
        return this.m_host == null ? "${ipaddr}" : this.m_host;
    }

    public void setHost(String value) {
        this.m_host = ConfigUtils.normalizeString(value);
    }

    public int getPort() {
        return this.m_port == null ? 80 : this.m_port;
    }

    public void setPort(Integer value) {
        this.m_port = value;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String value) {
        this.m_path = ConfigUtils.assertNotEmpty(value, "path");
    }

    public Optional<String> getQuery() {
        return Optional.ofNullable(this.m_query);
    }

    public void setQuery(String value) {
        this.m_query = ConfigUtils.normalizeString(value);
    }

    public Optional<String> getFragment() {
        return Optional.ofNullable(this.m_fragment);
    }

    public void setFragment(String value) {
        this.m_fragment = ConfigUtils.normalizeString(value);
    }

    public String getMatches() {
        return this.m_matches == null ? "(.*)" : this.m_matches;
    }

    public void setMatches(String value) {
        this.m_matches = ConfigUtils.normalizeString(value);
    }

    public String getResponseRange() {
        return this.m_responseRange == null ? "100-399" : this.m_responseRange;
    }

    public void setResponseRange(String value) {
        this.m_responseRange = ConfigUtils.normalizeString(value);
    }

    public boolean isCanonicalEquivalence() {
        return this.m_canonicalEquivalence == null ? false : this.m_canonicalEquivalence;
    }

    public void setCanonicalEquivalence(Boolean value) {
        this.m_canonicalEquivalence = value;
    }

    public boolean isCaseInsensitive() {
        return this.m_caseInsensitive == null ? false : this.m_caseInsensitive;
    }

    public void setCaseInsensitive(Boolean value) {
        this.m_caseInsensitive = value;
    }

    public boolean isComments() {
        return this.m_comments == null ? false : this.m_comments;
    }

    public void setComments(Boolean value) {
        this.m_comments = value;
    }

    public boolean isDotall() {
        return this.m_dotall == null ? false : this.m_dotall;
    }

    public void setDotall(Boolean value) {
        this.m_dotall = value;
    }

    public boolean isLiteral() {
        return this.m_literal == null ? false : this.m_literal;
    }

    public void setLiteral(Boolean value) {
        this.m_literal = value;
    }

    public boolean isMultiline() {
        return this.m_multiline == null ? false : this.m_multiline;
    }

    public void setMultiline(Boolean value) {
        this.m_multiline = value;
    }

    public boolean isUnicodeCase() {
        return this.m_unicodeCase == null ? false : this.m_unicodeCase;
    }

    public void setUnicodeCase(Boolean value) {
        this.m_unicodeCase = value;
    }

    public boolean isUnixLines() {
        return this.m_unixLines == null ? false : this.m_unixLines;
    }

    public void setUnixLines(Boolean value) {
        this.m_unixLines = value;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Url)) {
            return false;
        }
        Url that = (Url)other;
        return Objects.equals(this.m_parameters, that.m_parameters) && Objects.equals(this.m_method, that.m_method) && Objects.equals(this.m_httpVersion, that.m_httpVersion) && Objects.equals(this.m_userAgent, that.m_userAgent) && Objects.equals(this.m_virtualHost, that.m_virtualHost) && Objects.equals(this.m_scheme, that.m_scheme) && Objects.equals(this.m_userInfo, that.m_userInfo) && Objects.equals(this.m_host, that.m_host) && Objects.equals(this.m_port, that.m_port) && Objects.equals(this.m_path, that.m_path) && Objects.equals(this.m_query, that.m_query) && Objects.equals(this.m_fragment, that.m_fragment) && Objects.equals(this.m_matches, that.m_matches) && Objects.equals(this.m_responseRange, that.m_responseRange) && Objects.equals(this.m_canonicalEquivalence, that.m_canonicalEquivalence) && Objects.equals(this.m_caseInsensitive, that.m_caseInsensitive) && Objects.equals(this.m_comments, that.m_comments) && Objects.equals(this.m_dotall, that.m_dotall) && Objects.equals(this.m_literal, that.m_literal) && Objects.equals(this.m_multiline, that.m_multiline) && Objects.equals(this.m_unicodeCase, that.m_unicodeCase) && Objects.equals(this.m_unixLines, that.m_unixLines);
    }

    public int hashCode() {
        return Objects.hash(this.m_parameters, this.m_method, this.m_httpVersion, this.m_userAgent, this.m_virtualHost, this.m_scheme, this.m_userInfo, this.m_host, this.m_port, this.m_path, this.m_query, this.m_fragment, this.m_matches, this.m_responseRange, this.m_canonicalEquivalence, this.m_caseInsensitive, this.m_comments, this.m_dotall, this.m_literal, this.m_multiline, this.m_unicodeCase, this.m_unixLines);
    }
}

