/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.discovery;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="include-url")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="discovery-configuration.xsd")
public class IncludeUrl
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlValue
    private String url;
    @XmlAttribute(name="location")
    private String location;
    @XmlAttribute(name="retries")
    private Integer retries;
    @XmlAttribute(name="timeout")
    private Long timeout;
    @XmlAttribute(name="foreign-source")
    private String foreignSource;

    public IncludeUrl() {
    }

    public IncludeUrl(String url) {
        this.url = url;
    }

    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public void setUrl(String url) {
        this.url = ConfigUtils.assertNotEmpty(url, "URL");
    }

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public void setLocation(String location) {
        this.location = ConfigUtils.normalizeString(location);
    }

    public Optional<Integer> getRetries() {
        return Optional.ofNullable(this.retries);
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public void setTimeout(Long timeout) {
        if (timeout != null && timeout == 0L) {
            throw new IllegalArgumentException("Can't have a 0 timeout!");
        }
        this.timeout = timeout;
    }

    public Optional<String> getForeignSource() {
        return Optional.ofNullable(this.foreignSource);
    }

    public void setForeignSource(String foreignSource) {
        this.foreignSource = ConfigUtils.normalizeString(foreignSource);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.location, this.retries, this.timeout, this.foreignSource);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IncludeUrl) {
            IncludeUrl temp = (IncludeUrl)obj;
            return Objects.equals(temp.url, this.url) && Objects.equals(temp.location, this.location) && Objects.equals(temp.retries, this.retries) && Objects.equals(temp.timeout, this.timeout) && Objects.equals(temp.foreignSource, this.foreignSource);
        }
        return false;
    }

    public String toString() {
        return "IncludeUrl [value=" + this.url + ", location=" + this.location + ", retries=" + this.retries + ", timeout=" + this.timeout + ", foreignSource=" + this.foreignSource + "]";
    }
}

