/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.rest.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import net.redhogs.cronparser.CronExpressionDescriptor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfig;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigDao;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigQueryResult;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigStatus;
import org.opennms.features.deviceconfig.rest.BackupRequestDTO;
import org.opennms.features.deviceconfig.rest.BackupResponseDTO;
import org.opennms.features.deviceconfig.rest.api.DeviceConfigDTO;
import org.opennms.features.deviceconfig.rest.api.DeviceConfigRestService;
import org.opennms.features.deviceconfig.rest.impl.CompressionUtils;
import org.opennms.features.deviceconfig.service.DeviceConfigService;
import org.opennms.features.usageanalytics.api.UsageAnalyticDao;
import org.opennms.features.usageanalytics.api.UsageAnalyticMetricName;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.utils.ResponseUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionOperations;

public class DefaultDeviceConfigRestService
implements DeviceConfigRestService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDeviceConfigRestService.class);
    public static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    public static final String BINARY_ENCODING = "binary";
    private final TransactionOperations operations;
    private UsageAnalyticDao usageAnalyticDao;
    private static final Map<String, String> ORDERBY_QUERY_PROPERTY_MAP = Map.of("lastupdated", "lastUpdated", "devicename", "ipInterface.node.label", "lastbackup", "createdTime", "ipaddress", "ipInterface.ipAddr", "location", "ipInterface.node.location.locationName", "status", "status");
    private final DeviceConfigDao deviceConfigDao;
    private final DeviceConfigService deviceConfigService;

    public DefaultDeviceConfigRestService(DeviceConfigDao deviceConfigDao, DeviceConfigService deviceConfigService, TransactionOperations operations) {
        this.deviceConfigDao = deviceConfigDao;
        this.deviceConfigService = deviceConfigService;
        this.operations = Objects.requireNonNull(operations);
    }

    public void setUsageAnalyticDao(UsageAnalyticDao usageAnalyticDao) {
        this.usageAnalyticDao = usageAnalyticDao;
    }

    @Override
    public Response getDeviceConfig(long id) {
        DeviceConfig dc = (DeviceConfig)this.deviceConfigDao.get((Serializable)Long.valueOf(id));
        if (dc == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)this.createDeviceConfigDto(dc)).build();
    }

    @Override
    public Response getDeviceConfigs(Integer limit, Integer offset, String orderBy, String order, String deviceName, String ipAddress, Integer ipInterfaceId, String configType, Set<DeviceConfigStatus> statuses, Long createdAfter, Long createdBefore) {
        Criteria criteria = this.getCriteria(limit, offset, orderBy, order, deviceName, ipAddress, ipInterfaceId, configType, statuses, createdAfter, createdBefore);
        List dtos = this.deviceConfigDao.findMatching(criteria).stream().map(this::createDeviceConfigDto).filter(Objects::nonNull).collect(Collectors.toList());
        long offsetToUse = offset != null ? offset.longValue() : 0L;
        int totalCount = dtos.size();
        if (limit != null || offset != null) {
            criteria.setLimit(null);
            criteria.setOffset(null);
            totalCount = this.deviceConfigDao.countMatching(criteria);
        }
        return ResponseUtils.createResponse(dtos, (long)offsetToUse, (long)totalCount);
    }

    @Override
    public Response getLatestDeviceConfigsForDeviceAndConfigType(Integer limit, Integer offset, String orderBy, String order, String searchTerm, Set<DeviceConfigStatus> statuses, boolean pageEnter) {
        if (pageEnter) {
            this.operations.execute(status -> {
                this.usageAnalyticDao.incrementCounterByMetricName(UsageAnalyticMetricName.DCB_WEBUI_ENTRY.toString());
                return null;
            });
        }
        List dtos = this.deviceConfigDao.getLatestConfigForEachInterface(limit, offset, orderBy, order, searchTerm, statuses).stream().map(this::createDeviceConfigDto).filter(Objects::nonNull).collect(Collectors.toList());
        int totalCount = limit != null || offset != null ? this.deviceConfigDao.getLatestConfigCountForEachInterface(searchTerm, statuses) : dtos.size();
        long offsetForResponse = offset != null ? offset.longValue() : 0L;
        return ResponseUtils.createResponse(dtos, (long)offsetForResponse, (long)totalCount);
    }

    @Override
    public Response getDeviceConfigsByInterface(Integer ipInterfaceId, String configType) {
        Criteria criteria = this.getCriteria(null, null, "lastUpdated", "desc", null, null, ipInterfaceId, configType, null, null, null);
        List dtos = this.deviceConfigDao.findMatching(criteria).stream().map(this::createDeviceConfigDto).filter(Objects::nonNull).collect(Collectors.toList());
        long offsetToUse = 0L;
        int totalCount = dtos.size();
        return ResponseUtils.createResponse(dtos, (long)0L, (long)totalCount);
    }

    @Override
    public Response deleteDeviceConfigs(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            LOG.debug("Bad request : empty or null DeviceConfig Id");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid 'id' parameter").build();
        }
        return (Response)this.operations.execute(status -> {
            try {
                ArrayList<DeviceConfig> deviceConfigList = new ArrayList<DeviceConfig>();
                for (Long id : ids) {
                    DeviceConfig dc = (DeviceConfig)this.deviceConfigDao.get((Serializable)id);
                    if (dc == null) {
                        LOG.debug("could not find device config data for id: {}", (Object)id);
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Invalid 'id' parameter").build();
                    }
                    deviceConfigList.add(dc);
                }
                this.deviceConfigDao.deleteDeviceConfigs(deviceConfigList);
                return Response.noContent().build();
            }
            catch (Exception e) {
                LOG.error("Exception while deleting device configs, one or more ids not valid {}", (Throwable)e);
                return Response.noContent().build();
            }
        });
    }

    @Override
    public Response deleteDeviceConfig(long id) {
        return (Response)this.operations.execute(status -> {
            try {
                DeviceConfig dc = (DeviceConfig)this.deviceConfigDao.get((Serializable)Long.valueOf(id));
                if (dc == null) {
                    LOG.debug("could not find device config data for id: {}", (Object)id);
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Invalid 'id' parameter").build();
                }
                this.deviceConfigDao.delete((Object)dc);
                return Response.noContent().build();
            }
            catch (Exception e) {
                LOG.error("Exception while deleting device config, provided id is not valid {}", (Throwable)e);
                return Response.noContent().build();
            }
        });
    }

    @Override
    public Response downloadDeviceConfig(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            LOG.debug("downloadDeviceConfig: empty or null id supplied by request");
            return Response.noContent().build();
        }
        String idParamPattern = "\\d+(, ?\\d+)*";
        Pattern pattern = Pattern.compile("\\d+(, ?\\d+)*");
        Matcher matcher = pattern.matcher(id);
        if (!matcher.matches()) {
            LOG.debug("downloadDeviceConfig: invalid id param supplied by request");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid 'id' parameter").build();
        }
        List<Long> ids = Arrays.stream(id.split(",")).filter(s -> !Strings.isNullOrEmpty((String)s)).map(Long::parseLong).collect(Collectors.toList());
        if (ids.isEmpty()) {
            LOG.debug("downloadDeviceConfig: no ids supplied by request");
            return Response.noContent().build();
        }
        if (ids.size() == 1) {
            return this.downloadSingleDeviceConfig(ids.get(0));
        }
        return this.downloadMultipleDeviceConfigs(ids);
    }

    private Response downloadSingleDeviceConfig(Long id) {
        DeviceConfig dc = (DeviceConfig)this.deviceConfigDao.get((Serializable)id);
        if (dc == null || dc.getConfig() == null || dc.getConfig().length == 0) {
            LOG.debug("could not find device config data for id: {}", (Object)id);
            return Response.noContent().build();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(dc.getConfig(), 0, dc.getConfig().length);
        String fileName = DefaultDeviceConfigRestService.createDownloadFileName(dc);
        Charset charset = DefaultDeviceConfigRestService.getEncodingCharset(dc.getEncoding());
        return Response.ok().type("text/plain;charset=" + charset.name()).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).header("Pragma", (Object)"public").header("Cache-Control", (Object)"cache").header("Cache-Control", (Object)"must-revalidate").entity((Object)outputStream.toByteArray()).build();
    }

    private Response downloadMultipleDeviceConfigs(List<Long> ids) {
        Map<String, byte[]> fileNameToDataMap = ids.stream().map(arg_0 -> ((DeviceConfigDao)this.deviceConfigDao).get(arg_0)).filter(dc -> dc != null && dc.getConfig() != null && dc.getConfig().length > 0).collect(Collectors.toMap(dc -> DefaultDeviceConfigRestService.createDownloadFileName(dc), dc -> dc.getConfig()));
        if (fileNameToDataMap.isEmpty()) {
            LOG.debug("no config data found for request");
            return Response.noContent().build();
        }
        byte[] gzipBytes = null;
        try {
            gzipBytes = CompressionUtils.tarGzipMultipleFiles(fileNameToDataMap);
        }
        catch (IOException e) {
            String message = "Error compressing multiple files for download.";
            LOG.error(message, (Throwable)e);
            throw this.getException(Response.Status.INTERNAL_SERVER_ERROR, message);
        }
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("YYYYMMdd-HHmmss");
        String timestamp = formatter.format(currentTime);
        String fileName = "device-configs-" + timestamp + ".tar.gz";
        return Response.ok().type("application/gzip").header("Content-Disposition", (Object)("attachment; filename=" + fileName)).header("Pragma", (Object)"public").header("Cache-Control", (Object)"cache").header("Cache-Control", (Object)"must-revalidate").entity((Object)gzipBytes).build();
    }

    public static String createDownloadFileName(String deviceName, String ipAddress, String configType, Date createdTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("YYYYMMdd-HHmmss");
        List<String> items = List.of(!Strings.isNullOrEmpty((String)deviceName) ? deviceName : "device", !Strings.isNullOrEmpty((String)ipAddress) ? ipAddress.replace('.', '_') : "ipaddress", !Strings.isNullOrEmpty((String)configType) ? configType : "default", formatter.format(createdTime));
        String fileName = String.join((CharSequence)"-", items) + ".cfg";
        return fileName;
    }

    private static ScheduleInfo getScheduleInfo(Date current, String schedulePattern) {
        String cronDescription;
        if (Strings.isNullOrEmpty((String)schedulePattern) || "never".equalsIgnoreCase(schedulePattern)) {
            return new ScheduleInfo(null, "Never");
        }
        try {
            cronDescription = CronExpressionDescriptor.getDescription((String)schedulePattern);
        }
        catch (ParseException pe) {
            LOG.error("Invalid cron expression {}", (Object)schedulePattern, (Object)pe);
            return new ScheduleInfo(null, "Invalid Schedule");
        }
        try {
            Date nextScheduledBackup = DefaultDeviceConfigRestService.getNextRunDate(schedulePattern, current);
            return new ScheduleInfo(nextScheduledBackup, cronDescription);
        }
        catch (Exception e) {
            LOG.error("Invalid cron expression {}", (Object)schedulePattern, (Object)e);
            return new ScheduleInfo(null, "Invalid Schedule");
        }
    }

    @Override
    public Response triggerDeviceConfigBackup(List<BackupRequestDTO> backupRequestDtoList) {
        if (backupRequestDtoList == null || backupRequestDtoList.isEmpty()) {
            String message = "Cannot trigger config backup on empty request list";
            LOG.error("Cannot trigger config backup on empty request list");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Cannot trigger config backup on empty request list").build();
        }
        ArrayList<BackupResponseDTO> backupResponses = new ArrayList<BackupResponseDTO>();
        for (BackupRequestDTO requestDto : backupRequestDtoList) {
            try {
                DeviceConfigService.DeviceConfigBackupResponse response = null;
                if (requestDto.getBlocking().booleanValue()) {
                    response = (DeviceConfigService.DeviceConfigBackupResponse)this.deviceConfigService.triggerConfigBackup(requestDto.getIpAddress(), requestDto.getLocation(), requestDto.getServiceName(), true).get();
                } else {
                    this.deviceConfigService.triggerConfigBackup(requestDto.getIpAddress(), requestDto.getLocation(), requestDto.getServiceName(), true);
                }
                if (response == null || Strings.isNullOrEmpty((String)response.getErrorMessage())) continue;
                LOG.error("Unable to trigger config backup for {} at location {} with configType {}", new Object[]{requestDto.getIpAddress(), requestDto.getLocation(), requestDto.getServiceName()});
                backupResponses.add(new BackupResponseDTO(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), response.getErrorMessage(), requestDto));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unable to trigger config backup for {} at location {} with configType {}", new Object[]{requestDto.getIpAddress(), requestDto.getLocation(), requestDto.getServiceName()});
                backupResponses.add(new BackupResponseDTO(Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage(), requestDto));
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                LOG.error("Unable to trigger config backup for {} at location {} with configType {}", new Object[]{requestDto.getIpAddress(), requestDto.getLocation(), requestDto.getServiceName()});
                backupResponses.add(new BackupResponseDTO(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage(), requestDto));
            }
        }
        if (backupResponses.isEmpty()) {
            return Response.accepted().build();
        }
        if (backupRequestDtoList.size() == 1 && backupResponses.size() == 1) {
            BackupResponseDTO singleResponse = (BackupResponseDTO)backupResponses.get(0);
            return Response.status((int)singleResponse.getStatus()).entity((Object)singleResponse.getFailureMessage()).build();
        }
        return Response.status((int)207).entity(backupResponses).build();
    }

    private Criteria getCriteria(Integer limit, Integer offset, String orderBy, String order, String deviceName, String ipAddress, Integer ipInterfaceId, String configType, Set<DeviceConfigStatus> statuses, Long createdAfter, Long createdBefore) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(DeviceConfig.class);
        if (limit != null) {
            criteriaBuilder.limit(limit);
        }
        if (offset != null) {
            criteriaBuilder.offset(offset);
        }
        String string = orderBy = orderBy != null ? orderBy.toLowerCase(Locale.ROOT) : null;
        if (!Strings.isNullOrEmpty((String)orderBy) && ORDERBY_QUERY_PROPERTY_MAP.containsKey(orderBy)) {
            String orderByToUse = ORDERBY_QUERY_PROPERTY_MAP.get(orderBy);
            boolean isOrderAscending = Strings.isNullOrEmpty((String)order) || !"desc".equals(order);
            criteriaBuilder.orderBy(orderByToUse, isOrderAscending);
        } else {
            criteriaBuilder.orderBy("lastUpdated", false);
        }
        if (!Strings.isNullOrEmpty((String)deviceName)) {
            criteriaBuilder.ilike("ipInterface.node.label", (Object)deviceName);
        }
        if (!Strings.isNullOrEmpty((String)ipAddress)) {
            criteriaBuilder.ilike("ipInterface.ipAddr", (Object)ipAddress);
        }
        if (ipInterfaceId != null) {
            criteriaBuilder.eq("ipInterface.id", (Object)ipInterfaceId);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{configType})) {
            criteriaBuilder.ilike("configType", (Object)configType);
        }
        if (statuses != null && !statuses.isEmpty()) {
            List restrictions = statuses.stream().map(status -> Restrictions.ilike((String)"status", (Object)status.name())).collect(Collectors.toList());
            criteriaBuilder.or((Restriction[])restrictions.stream().toArray(Restriction[]::new));
        }
        if (createdAfter != null) {
            criteriaBuilder.ge("createdTime", (Object)new Date(createdAfter));
        }
        if (createdBefore != null) {
            criteriaBuilder.le("createdTime", (Object)new Date(createdBefore));
        }
        return criteriaBuilder.toCriteria();
    }

    private WebApplicationException getException(Response.Status status, String message) {
        return new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)message).build());
    }

    private DeviceConfigDTO createDeviceConfigDto(DeviceConfigQueryResult queryResult) {
        Pair<String, String> pair = DefaultDeviceConfigRestService.configToText(queryResult.getEncoding(), queryResult.getConfig());
        String encoding = (String)pair.getLeft();
        String config = (String)pair.getRight();
        DeviceConfigDTO dto = new DeviceConfigDTO();
        dto.setId(queryResult.getId());
        dto.setServiceName(queryResult.getServiceName());
        dto.setIpAddress(queryResult.getIpAddr());
        dto.setLastBackupDate(queryResult.getCreatedTime());
        dto.setLastUpdatedDate(queryResult.getLastUpdated());
        dto.setLastSucceededDate(queryResult.getLastSucceeded());
        dto.setLastFailedDate(queryResult.getLastFailed());
        dto.setEncoding(encoding);
        dto.setConfigType(queryResult.getConfigType());
        dto.setConfigName(DefaultDeviceConfigRestService.createConfigName(queryResult.getServiceName()));
        dto.setFileName(queryResult.getFilename());
        dto.setConfig(config);
        dto.setFailureReason(queryResult.getFailureReason());
        DeviceConfigStatus backupStatus = queryResult.getStatusOrDefault();
        dto.setIsSuccessfulBackup(backupStatus.equals((Object)DeviceConfigStatus.SUCCESS));
        dto.setBackupStatus(backupStatus.name().toLowerCase(Locale.ROOT));
        dto.setIpInterfaceId(queryResult.getIpInterfaceId());
        dto.setNodeId(queryResult.getNodeId());
        dto.setNodeLabel(queryResult.getNodeLabel());
        dto.setDeviceName(queryResult.getNodeLabel());
        dto.setLocation(queryResult.getLocation());
        dto.setOperatingSystem(queryResult.getOperatingSystem());
        this.populateScheduleInfo(dto);
        return dto;
    }

    private DeviceConfigDTO createDeviceConfigDto(DeviceConfig deviceConfig) {
        Pair<String, String> pair = DefaultDeviceConfigRestService.configToText(deviceConfig.getEncoding(), deviceConfig.getConfig());
        String encoding = (String)pair.getLeft();
        String config = (String)pair.getRight();
        DeviceConfigDTO dto = new DeviceConfigDTO();
        dto.setId(deviceConfig.getId());
        dto.setServiceName(deviceConfig.getServiceName());
        dto.setIpAddress(InetAddressUtils.str((InetAddress)deviceConfig.getIpInterface().getIpAddress()));
        dto.setLastBackupDate(deviceConfig.getCreatedTime());
        dto.setLastUpdatedDate(deviceConfig.getLastUpdated());
        dto.setLastSucceededDate(deviceConfig.getLastSucceeded());
        dto.setLastFailedDate(deviceConfig.getLastFailed());
        dto.setEncoding(encoding);
        dto.setConfigType(deviceConfig.getConfigType());
        dto.setConfigName(DefaultDeviceConfigRestService.createConfigName(deviceConfig.getServiceName()));
        dto.setFileName(deviceConfig.getFileName());
        dto.setConfig(config);
        dto.setFailureReason(deviceConfig.getFailureReason());
        DeviceConfigStatus backupStatus = deviceConfig.getStatusOrDefault();
        dto.setIsSuccessfulBackup(backupStatus.equals((Object)DeviceConfigStatus.SUCCESS));
        dto.setBackupStatus(backupStatus.name().toLowerCase(Locale.ROOT));
        OnmsIpInterface ipInterface = deviceConfig.getIpInterface();
        OnmsNode node = ipInterface.getNode();
        dto.setIpInterfaceId(ipInterface.getId());
        dto.setNodeId(node.getId());
        dto.setNodeLabel(node.getLabel());
        dto.setDeviceName(node.getLabel());
        dto.setLocation(node.getLocation().getLocationName());
        dto.setOperatingSystem(node.getOperatingSystem());
        this.populateScheduleInfo(dto);
        return dto;
    }

    private void populateScheduleInfo(DeviceConfigDTO dto) {
        Date currentDate = new Date();
        Map<String, ScheduleInfo> schedules = this.deviceConfigService.getRetrievalDefinitions(dto.getIpAddress(), dto.getLocation()).stream().filter(ret -> Objects.equals(ret.getConfigType(), dto.getConfigType())).collect(Collectors.toMap(DeviceConfigService.RetrievalDefinition::getServiceName, ret -> DefaultDeviceConfigRestService.getScheduleInfo(currentDate, ret.getSchedule())));
        dto.setScheduledInterval(Maps.transformValues(schedules, ScheduleInfo::getScheduleInterval));
        schedules.values().stream().map(ScheduleInfo::getNextScheduledBackup).filter(v -> v != null).min(Date::compareTo).ifPresent(dto::setNextScheduledBackupDate);
    }

    private static Date getNextRunDate(String cronSchedule, Date lastRun) {
        Trigger trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronSchedule)).startAt(lastRun).build();
        return trigger.getFireTimeAfter(lastRun);
    }

    private static Pair<String, String> configToText(String encoding, byte[] configBytes) {
        boolean isBinaryEncoding;
        boolean bl = isBinaryEncoding = !Strings.isNullOrEmpty((String)encoding) && encoding.equals(BINARY_ENCODING);
        if (isBinaryEncoding) {
            String config = configBytes != null ? DatatypeConverter.printHexBinary((byte[])configBytes) : "";
            return Pair.of((Object)BINARY_ENCODING, (Object)config);
        }
        Charset charset = DefaultDeviceConfigRestService.getEncodingCharset(encoding);
        String config = configBytes != null ? new String(configBytes, charset) : "";
        return Pair.of((Object)charset.name(), (Object)config);
    }

    private static Charset getEncodingCharset(String encoding) {
        return !Strings.isNullOrEmpty((String)encoding) && Charset.isSupported(encoding) ? Charset.forName(encoding) : Charset.defaultCharset();
    }

    private static String createDownloadFileName(DeviceConfig dc) {
        OnmsIpInterface ipInterface = dc.getIpInterface();
        String ipAddress = InetAddressUtils.str((InetAddress)ipInterface.getIpAddress());
        String deviceName = ipInterface.getNode().getLabel();
        return DefaultDeviceConfigRestService.createDownloadFileName(deviceName, ipAddress, dc.getConfigType(), dc.getCreatedTime());
    }

    private static String createConfigName(String serviceName) {
        String suffix;
        if (Strings.isNullOrEmpty((String)serviceName) || !serviceName.startsWith("DeviceConfig")) {
            return serviceName;
        }
        int index = serviceName.indexOf(45);
        String string = suffix = index >= 0 ? serviceName.substring(index + 1) : "";
        if (index < 0 || suffix.toLowerCase(Locale.ROOT).equals("default")) {
            return "Startup Configuration";
        }
        String name = Arrays.stream(suffix.split("-")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        return name + " Configuration";
    }

    private static class ScheduleInfo {
        private final Date nextScheduledBackup;
        private final String scheduleInterval;

        public Date getNextScheduledBackup() {
            return this.nextScheduledBackup;
        }

        public String getScheduleInterval() {
            return this.scheduleInterval;
        }

        public ScheduleInfo(Date nextScheduledBackup, String scheduleInterval) {
            this.nextScheduledBackup = nextScheduledBackup;
            this.scheduleInterval = scheduleInterval;
        }
    }
}

