/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.Map;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.TimerExpression;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.BaseTimer;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.IntervalTrigger;
import org.drools.core.time.impl.Timer;
import org.kie.api.runtime.Calendars;

public class IntervalTimer
extends BaseTimer
implements Timer,
Externalizable {
    private TimerExpression startTime;
    private TimerExpression endTime;
    private int repeatLimit;
    private long delay;
    private long period;

    public IntervalTimer() {
    }

    public IntervalTimer(TimerExpression startTime, TimerExpression endTime, int repeatLimit, long delay, long period) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.repeatLimit = repeatLimit;
        this.delay = delay;
        this.period = period;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.startTime);
        out.writeObject(this.endTime);
        out.writeInt(this.repeatLimit);
        out.writeLong(this.delay);
        out.writeLong(this.period);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startTime = (TimerExpression)in.readObject();
        this.endTime = (TimerExpression)in.readObject();
        this.repeatLimit = in.readInt();
        this.delay = in.readLong();
        this.period = in.readLong();
    }

    private Declaration[] getStartDeclarations() {
        return this.startTime != null ? this.startTime.getDeclarations() : null;
    }

    private Declaration[] getEndDeclarations() {
        return this.endTime != null ? this.endTime.getDeclarations() : null;
    }

    @Override
    public Declaration[][] getTimerDeclarations(Map<String, Declaration> outerDeclrs) {
        return new Declaration[][]{this.sortDeclarations(outerDeclrs, this.getStartDeclarations()), this.sortDeclarations(outerDeclrs, this.getEndDeclarations())};
    }

    public long getDelay() {
        return this.delay;
    }

    public long getPeriod() {
        return this.period;
    }

    @Override
    public Trigger createTrigger(long timestamp, Tuple leftTuple, DefaultJobHandle jh, String[] calendarNames, Calendars calendars, Declaration[][] declrs, ReteEvaluator reteEvaluator) {
        Declaration[] startDeclarations = declrs[0];
        Date lastFireTime = null;
        Date createdTime = null;
        long newDelay = this.delay;
        if (jh != null) {
            IntervalTrigger preTrig = (IntervalTrigger)jh.getTimerJobInstance().getTrigger();
            lastFireTime = preTrig.getLastFireTime();
            createdTime = preTrig.getCreatedTime();
            newDelay = lastFireTime != null ? this.period - timestamp + lastFireTime.getTime() : this.delay - timestamp + createdTime.getTime();
        }
        if (newDelay < 0L) {
            newDelay = 0L;
        }
        return new IntervalTrigger(timestamp, TimeUtils.evalDateExpression(this.startTime, leftTuple, startDeclarations, reteEvaluator), TimeUtils.evalDateExpression(this.endTime, leftTuple, startDeclarations, reteEvaluator), this.repeatLimit, newDelay, this.period, calendarNames, calendars, createdTime, lastFireTime);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        return new IntervalTrigger(timestamp, null, null, this.repeatLimit, this.delay, this.period, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (int)(this.period ^ this.period >>> 32);
        result = 31 * result + this.repeatLimit;
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalTimer other = (IntervalTimer)obj;
        if (this.delay != other.delay) {
            return false;
        }
        if (this.repeatLimit != other.repeatLimit) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }

    @Override
    public ConditionalElement clone() {
        return new IntervalTimer(this.startTime, this.endTime, this.repeatLimit, this.delay, this.period);
    }
}

