/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.facttemplates;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.drools.core.base.ObjectType;
import org.drools.core.base.ValueType;
import org.drools.core.facttemplates.Fact;
import org.drools.core.facttemplates.FactTemplate;

public class FactTemplateObjectType
implements ObjectType {
    private static final long serialVersionUID = 510L;
    protected FactTemplate factTemplate;
    private boolean isEvent;

    public FactTemplateObjectType() {
    }

    public FactTemplateObjectType(FactTemplate factTemplate) {
        this.factTemplate = factTemplate;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.factTemplate = (FactTemplate)in.readObject();
        this.isEvent = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.factTemplate);
        out.writeBoolean(this.isEvent);
    }

    public FactTemplate getFactTemplate() {
        return this.factTemplate;
    }

    public boolean matches(Object object) {
        if (object instanceof Fact) {
            return this.factTemplate.equals(((Fact)object).getFactTemplate());
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(Class<?> clazz) {
        return false;
    }

    @Override
    public boolean isAssignableTo(Class<?> clazz) {
        return false;
    }

    @Override
    public boolean isAssignableFrom(ObjectType objectType) {
        if (!(objectType instanceof FactTemplateObjectType)) {
            return false;
        }
        return this.factTemplate.equals(((FactTemplateObjectType)objectType).getFactTemplate());
    }

    @Override
    public ValueType getValueType() {
        return ValueType.FACTTEMPLATE_TYPE;
    }

    @Override
    public boolean isEvent() {
        return this.isEvent;
    }

    public void setEvent(boolean isEvent) {
        this.isEvent = isEvent;
    }

    @Override
    public Object getTypeKey() {
        return this.factTemplate.getName();
    }

    @Override
    public boolean isTemplate() {
        return true;
    }

    @Override
    public String getClassName() {
        return this.factTemplate.getPackage() + "." + this.factTemplate.getName();
    }

    @Override
    public boolean hasField(String name) {
        return this.factTemplate.getFieldTemplate(name) != null;
    }

    public Collection<String> getFieldNames() {
        return this.factTemplate.getFieldNames();
    }

    public String toString() {
        return "[FactTemplateObjectType " + (this.isEvent ? "event=" : "template=") + this.factTemplate.getName() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FactTemplateObjectType)) {
            return false;
        }
        FactTemplateObjectType other = (FactTemplateObjectType)object;
        return this.factTemplate.equals(other.factTemplate);
    }

    public int hashCode() {
        return this.factTemplate.hashCode();
    }
}

