/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.concurrent.AbstractRuleEvaluator;
import org.drools.core.concurrent.RuleEvaluator;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.rule.consequence.Activation;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.internal.concurrent.ExecutorProviderFactory;

public class ParallelRuleEvaluator
extends AbstractRuleEvaluator
implements RuleEvaluator {
    private static final RuleAgendaItem POISON_PILL = new RuleAgendaItem();
    private final int evaluatorsNr = RuleBasePartitionId.PARALLEL_PARTITIONS_NUMBER;
    private RuleEvaluatorCallable[] evaluators = new RuleEvaluatorCallable[this.evaluatorsNr];
    private Future<Integer>[] results = new Future[this.evaluatorsNr];
    private AgendaFilter filter;
    private int fireCount;
    private int fireLimit;

    public ParallelRuleEvaluator(ActivationsManager activationsManager) {
        super(activationsManager);
        for (int i = 0; i < this.evaluatorsNr; ++i) {
            this.evaluators[i] = new RuleEvaluatorCallable();
        }
    }

    @Override
    public int evaluateAndFire(AgendaFilter filter, int fireCount, int fireLimit, InternalAgendaGroup group) {
        Activation[] activations;
        this.filter = filter;
        this.fireCount = fireCount;
        this.fireLimit = fireLimit;
        for (Activation activation : activations = group.getActivations()) {
            RuleAgendaItem item = (RuleAgendaItem)activation;
            int index = item.getPartition().getParallelEvaluationSlot();
            RuleEvaluatorCallable evaluator = this.evaluators[index];
            evaluator.enqueue(item);
            if (evaluator.running) continue;
            evaluator.running = true;
            this.results[index] = Completion.service.submit(evaluator);
        }
        int localFireCount = 0;
        for (int i = 0; i < this.evaluatorsNr; ++i) {
            if (this.results[i] == null) continue;
            try {
                this.evaluators[i].enqueue(POISON_PILL);
                localFireCount += this.results[i].get().intValue();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.results[i] = null;
            }
        }
        return localFireCount;
    }

    @Override
    public KnowledgeHelper getKnowledgeHelper() {
        throw new UnsupportedOperationException();
    }

    public class RuleEvaluatorCallable
    implements Callable<Integer> {
        private final BlockingQueue<RuleAgendaItem> queue = new LinkedBlockingQueue<RuleAgendaItem>();
        private final KnowledgeHelper knowledgeHelper = ParallelRuleEvaluator.this.newKnowledgeHelper();
        private boolean running = false;

        @Override
        public Integer call() {
            int count = 0;
            try {
                RuleAgendaItem item;
                while ((item = this.queue.take()) != POISON_PILL) {
                    count += ParallelRuleEvaluator.this.internalEvaluateAndFire(ParallelRuleEvaluator.this.filter, ParallelRuleEvaluator.this.fireCount, ParallelRuleEvaluator.this.fireLimit, item);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.running = false;
            return count;
        }

        private void enqueue(RuleAgendaItem item) {
            if (!this.queue.offer(item)) {
                throw new IllegalStateException("Cannot insert item into the queue! There is no space left in the queue.");
            }
        }
    }

    private static class Completion {
        private static final CompletionService<Integer> service = ExecutorProviderFactory.getExecutorProvider().getCompletionService();

        private Completion() {
        }
    }
}

