/*
 * Decompiled with CFR 0.152.
 */
package com.swrve.ratelimitedlogger;

import com.swrve.ratelimitedlogger.CounterMetric;
import com.swrve.ratelimitedlogger.Level;
import com.swrve.ratelimitedlogger.RateLimitedLogWithPattern;
import com.swrve.ratelimitedlogger.Stopwatch;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.Marker;

@ThreadSafe
public class LogWithPatternAndLevel {
    private static final long NOT_RATE_LIMITED_YET = 0L;
    private static final String RATE_LIMITED_COUNT_SUFFIX = "_rate_limited_log_count";
    private final String message;
    private final Level level;
    private final RateLimitedLogWithPattern.RateAndPeriod rateAndPeriod;
    private final Logger logger;
    @Nullable
    private final CounterMetric stats;
    private final Stopwatch stopwatch;
    private final AtomicLong counter = new AtomicLong(0L);
    private final AtomicLong rateLimitedAt = new AtomicLong(0L);

    LogWithPatternAndLevel(String message, Level level, RateLimitedLogWithPattern.RateAndPeriod rateAndPeriod, @Nullable CounterMetric stats, Stopwatch stopwatch, Logger logger) {
        this.message = message;
        this.level = level;
        this.rateAndPeriod = rateAndPeriod;
        this.logger = logger;
        this.stats = stats;
        this.stopwatch = stopwatch;
    }

    public void log(Object ... args) {
        if (!this.isRateLimited()) {
            this.level.log(this.logger, this.message, args);
        }
        this.incrementStats();
    }

    public void log(Throwable t) {
        if (!this.isRateLimited()) {
            this.level.log(this.logger, this.message, t);
        }
        this.incrementStats();
    }

    public void log(Marker marker, Object ... args) {
        if (!this.isRateLimited()) {
            this.level.log(this.logger, this.message, marker, args);
        }
        this.incrementStats();
    }

    public void log(Marker marker, Throwable t) {
        if (!this.isRateLimited()) {
            this.level.log(this.logger, this.message, marker, t);
        }
        this.incrementStats();
    }

    private boolean isRateLimited() {
        long count = this.counter.incrementAndGet();
        if (count < (long)this.rateAndPeriod.maxRate) {
            return false;
        }
        if (count >= (long)this.rateAndPeriod.maxRate && this.rateLimitedAt.get() == 0L) {
            this.haveJustExceededRateLimit();
            return false;
        }
        return true;
    }

    synchronized void periodicReset() {
        long whenLimited = this.rateLimitedAt.getAndSet(0L);
        if (whenLimited != 0L) {
            this.reportSuppression(whenLimited);
        }
    }

    @GuardedBy(value="this")
    private void reportSuppression(long whenLimited) {
        long count = this.counter.get();
        this.counter.addAndGet(-count);
        long numSuppressed = count - (long)this.rateAndPeriod.maxRate;
        if (numSuppressed == 0L) {
            return;
        }
        Duration howLong = Duration.ofMillis(this.elapsedMsecs()).minusMillis(whenLimited);
        this.level.log(this.logger, "(suppressed {} logs similar to '{}' in {})", numSuppressed, this.message, howLong);
    }

    private synchronized void haveJustExceededRateLimit() {
        this.rateLimitedAt.set(this.elapsedMsecs());
    }

    private long elapsedMsecs() {
        long elapsed = this.stopwatch.elapsedTime(TimeUnit.MILLISECONDS);
        if (elapsed == 0L) {
            ++elapsed;
        }
        return elapsed;
    }

    private void incrementStats() {
        if (this.stats != null) {
            this.stats.increment(this.level.getLevelName() + RATE_LIMITED_COUNT_SUFFIX);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogWithPatternAndLevel other = (LogWithPatternAndLevel)o;
        return other.level == this.level && this.message.equals(other.message);
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = 31 * result + this.level.hashCode();
        return result;
    }
}

