/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ForwardingList;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;

public class TLV<T extends Type<V, P>, V, P> {
    public final T type;
    public final int length;
    public final V value;

    public TLV(ByteBuf buffer, IntFunction<T> typer, P parameter, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
        int type = BufferUtils.uint16((ByteBuf)buffer);
        this.type = (Type)typer.apply(type);
        this.length = BufferUtils.uint16((ByteBuf)buffer);
        if (this.type != null) {
            this.value = this.type.parse(BufferUtils.slice((ByteBuf)buffer, (int)this.length), parameter, peerInfo);
        } else {
            BmpParser.RATE_LIMITED_LOG.debug("Unknown type: {}", (Object)type);
            this.value = null;
            BufferUtils.skip((ByteBuf)buffer, (int)this.length);
        }
    }

    public boolean isValid() {
        return this.type != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", this.type).add("length", this.length).add("value", this.value).toString();
    }

    @FunctionalInterface
    public static interface Type<V, P> {
        public V parse(ByteBuf var1, P var2, Optional<PeerInfo> var3) throws InvalidPacketException;
    }

    public static class List<E extends TLV<T, V, ?>, T extends Type<V, ?>, V>
    extends ForwardingList<E> {
        private final java.util.List<E> elements;

        private List(java.util.List<E> elements) {
            this.elements = elements;
        }

        public static <E extends TLV<T, V, ?>, T extends Type<V, ?>, V> List<E, T, V> wrap(java.util.List<E> list) {
            return new List<E, T, V>(list);
        }

        protected java.util.List<E> delegate() {
            return this.elements;
        }

        public Stream<V> all(T type) {
            return this.elements.stream().filter(e -> e.type == type).map(e -> e.value);
        }

        public Optional<V> first(T type) {
            return this.elements.stream().filter(e -> e.type == type).findFirst().map(e -> e.value);
        }
    }
}

