/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.drools;

import java.io.Serializable;
import java.util.Date;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.netmgt.alarmd.drools.AlarmTicketerService;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmEntityNotifier;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.events.EventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DefaultAlarmTicketerService
implements AlarmTicketerService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAlarmTicketerService.class);
    private static final boolean ALARM_TROUBLE_TICKET_ENABLED = Boolean.getBoolean("opennms.alarmTroubleTicketEnabled");
    @Autowired
    private AlarmDao alarmDao;
    @Autowired
    private EventForwarder eventForwarder;
    @Autowired
    private AlarmEntityNotifier alarmEntityNotifier;

    @Override
    public boolean isTicketingEnabled() {
        return ALARM_TROUBLE_TICKET_ENABLED;
    }

    @Override
    @Transactional
    public void createTicket(OnmsAlarm alarm, Date now) {
        this.eventForwarder.sendNow(new EventBuilder("uei.opennms.org/troubleTicket/create", DefaultAlarmTicketerService.class.getSimpleName()).addParam("alarmUei", alarm.getUei()).addParam("user", "admin").addParam("alarmId", alarm.getId().intValue()).getEvent());
        this.updateLastAutomationTime(alarm, now);
    }

    @Override
    @Transactional
    public void updateTicket(OnmsAlarm alarm, Date now) {
        this.eventForwarder.sendNow(new EventBuilder("uei.opennms.org/troubleTicket/update", DefaultAlarmTicketerService.class.getSimpleName()).addParam("alarmUei", alarm.getUei()).addParam("user", "admin").addParam("alarmId", alarm.getId().intValue()).addParam("troubleTicket", alarm.getTTicketId()).getEvent());
        this.updateLastAutomationTime(alarm, now);
    }

    @Override
    @Transactional
    public void closeTicket(OnmsAlarm alarm, Date now) {
        this.eventForwarder.sendNow(new EventBuilder("uei.opennms.org/troubleTicket/close", DefaultAlarmTicketerService.class.getSimpleName()).addParam("alarmUei", alarm.getUei()).addParam("user", "admin").addParam("alarmId", alarm.getId().intValue()).addParam("troubleTicket", alarm.getTTicketId()).getEvent());
        this.updateLastAutomationTime(alarm, now);
    }

    private void updateLastAutomationTime(OnmsAlarm alarm, Date now) {
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. lastAutomationTime will not be updated, instanceId={}, alarmId={}", new Object[]{alarm, SystemInfoUtils.getInstanceId(), alarm.getId()});
            return;
        }
        Date previousLastAutomationTime = alarmInTrans.getLastAutomationTime();
        alarmInTrans.setLastAutomationTime(now);
        this.alarmEntityNotifier.didUpdateLastAutomationTime(alarmInTrans, previousLastAutomationTime);
    }
}

