/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class InMemoryCircuitBreakerRegistry
extends AbstractRegistry<CircuitBreaker, CircuitBreakerConfig>
implements CircuitBreakerRegistry {
    public InMemoryCircuitBreakerRegistry() {
        this(CircuitBreakerConfig.ofDefaults());
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()));
        this.configurations.putAll(configs);
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    @Override
    public Seq<CircuitBreaker> getAllCircuitBreakers() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name) {
        return this.circuitBreaker(name, (CircuitBreakerConfig)this.getDefaultConfig());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, CircuitBreakerConfig config) {
        return (CircuitBreaker)this.computeIfAbsent(name, () -> CircuitBreaker.of(name, Objects.requireNonNull(config, "Config must not be null")));
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, String configName) {
        return (CircuitBreaker)this.computeIfAbsent(name, () -> CircuitBreaker.of(name, (CircuitBreakerConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName))));
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfigSupplier) {
        return (CircuitBreaker)this.computeIfAbsent(name, () -> CircuitBreaker.of(name, (CircuitBreakerConfig)Objects.requireNonNull(Objects.requireNonNull(circuitBreakerConfigSupplier, "Supplier must not be null").get(), "Config must not be null")));
    }
}

