/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Comparator;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.internals.RocksDbIterator;
import org.rocksdb.RocksIterator;

class RocksDBRangeIterator
extends RocksDbIterator {
    private final Comparator<byte[]> comparator = Bytes.BYTES_LEXICO_COMPARATOR;
    private final byte[] rawLastKey;
    private final boolean forward;
    private final boolean toInclusive;

    RocksDBRangeIterator(String storeName, RocksIterator iter, Bytes from, Bytes to, boolean forward, boolean toInclusive) {
        super(storeName, iter, forward);
        this.forward = forward;
        this.toInclusive = toInclusive;
        if (forward) {
            if (from == null) {
                iter.seekToFirst();
            } else {
                iter.seek(from.get());
            }
            this.rawLastKey = to == null ? null : to.get();
        } else {
            if (to == null) {
                iter.seekToLast();
            } else {
                iter.seekForPrev(to.get());
            }
            this.rawLastKey = from == null ? null : from.get();
        }
    }

    @Override
    public KeyValue<Bytes, byte[]> makeNext() {
        Object next = super.makeNext();
        if (next == null) {
            return (KeyValue)this.allDone();
        }
        if (this.rawLastKey == null) {
            return next;
        }
        if (this.forward) {
            if (this.comparator.compare(((Bytes)((KeyValue)next).key).get(), this.rawLastKey) < 0) {
                return next;
            }
            if (this.comparator.compare(((Bytes)((KeyValue)next).key).get(), this.rawLastKey) == 0) {
                return this.toInclusive ? next : (KeyValue)this.allDone();
            }
            return (KeyValue)this.allDone();
        }
        if (this.comparator.compare(((Bytes)((KeyValue)next).key).get(), this.rawLastKey) >= 0) {
            return next;
        }
        return (KeyValue)this.allDone();
    }
}

