/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1SetOf;
import com.novell.ldap.rfc2251.RfcAddRequest;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeList;
import com.novell.ldap.rfc2251.RfcAttributeTypeAndValues;
import com.novell.ldap.rfc2251.RfcAttributeValue;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;

public class LDAPAddRequest
extends LDAPMessage {
    public LDAPAddRequest() {
        super(8);
    }

    public LDAPAddRequest(LDAPEntry lDAPEntry, LDAPControl[] lDAPControlArray) throws LDAPException {
        super(8, new RfcAddRequest(new RfcLDAPDN(lDAPEntry.getDN()), LDAPAddRequest.makeRfcAttrList(lDAPEntry)), lDAPControlArray);
    }

    public LDAPEntry getEntry() {
        RfcAddRequest rfcAddRequest = (RfcAddRequest)this.getASN1Object().getRequest();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        ASN1Object[] aSN1ObjectArray = rfcAddRequest.getAttributes().toArray();
        for (int i = 0; i < aSN1ObjectArray.length; ++i) {
            RfcAttributeTypeAndValues rfcAttributeTypeAndValues = (RfcAttributeTypeAndValues)aSN1ObjectArray[i];
            LDAPAttribute lDAPAttribute = new LDAPAttribute(((ASN1OctetString)rfcAttributeTypeAndValues.get(0)).stringValue());
            ASN1SetOf aSN1SetOf = (ASN1SetOf)rfcAttributeTypeAndValues.get(1);
            ASN1Object[] aSN1ObjectArray2 = aSN1SetOf.toArray();
            for (int j = 0; j < aSN1ObjectArray2.length; ++j) {
                lDAPAttribute.addValue(((ASN1OctetString)aSN1ObjectArray2[j]).byteValue());
            }
            lDAPAttributeSet.add(lDAPAttribute);
        }
        return new LDAPEntry(this.getASN1Object().getRequestDN(), lDAPAttributeSet);
    }

    private static final RfcAttributeList makeRfcAttrList(LDAPEntry lDAPEntry) {
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        RfcAttributeList rfcAttributeList = new RfcAttributeList(lDAPAttributeSet.size());
        Iterator iterator = lDAPAttributeSet.iterator();
        while (iterator.hasNext()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)iterator.next();
            ASN1SetOf aSN1SetOf = new ASN1SetOf(lDAPAttribute.size());
            Enumeration enumeration = lDAPAttribute.getByteValues();
            while (enumeration.hasMoreElements()) {
                aSN1SetOf.add(new RfcAttributeValue((byte[])enumeration.nextElement()));
            }
            rfcAttributeList.add(new RfcAttributeTypeAndValues(new RfcAttributeDescription(lDAPAttribute.getName()), aSN1SetOf));
        }
        return rfcAttributeList;
    }

    public String toString() {
        return this.getASN1Object().toString();
    }

    protected void setDeserializedValues(LDAPMessage lDAPMessage, RfcControls rfcControls) throws IOException, ClassNotFoundException {
        if (!(lDAPMessage instanceof LDAPAddRequest)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPAddRequest object");
        }
        LDAPAddRequest lDAPAddRequest = (LDAPAddRequest)lDAPMessage;
        LDAPEntry lDAPEntry = lDAPAddRequest.getEntry();
        lDAPAddRequest = null;
        RfcAddRequest rfcAddRequest = new RfcAddRequest(new RfcLDAPDN(lDAPEntry.getDN()), LDAPAddRequest.makeRfcAttrList(lDAPEntry));
        this.message = new RfcLDAPMessage(rfcAddRequest, rfcControls);
        lDAPMessage = null;
    }
}

