/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.vaadin.extender.internal.servlet;

import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.UICreateEvent;
import com.vaadin.server.UIProvider;
import com.vaadin.server.UIProviderEvent;
import com.vaadin.ui.UI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.vaadin.extender.ApplicationFactory;

public class OSGiUIProvider
extends UIProvider {
    private Map<String, ApplicationFactory> factories = new HashMap<String, ApplicationFactory>();

    public OSGiUIProvider() {
    }

    public OSGiUIProvider(ApplicationFactory applicationFactory) {
        this.addApplicationFactory(applicationFactory);
    }

    public synchronized Class<? extends UI> getUIClass(UIClassSelectionEvent event) {
        ApplicationFactory applicationFactory;
        String uiClassName = this.extractUIClassName((UIProviderEvent)event);
        if (uiClassName != null && (applicationFactory = this.factories.get(uiClassName)) != null) {
            return applicationFactory.getUIClass();
        }
        return null;
    }

    public synchronized UI createInstance(UICreateEvent event) {
        String uiClassName = this.extractUIClassName((UIProviderEvent)event);
        if (uiClassName != null) {
            return this.factories.get(uiClassName).createUI();
        }
        return null;
    }

    public synchronized void addApplicationFactory(ApplicationFactory applicationFactory) {
        Objects.requireNonNull(applicationFactory);
        Objects.requireNonNull(applicationFactory.getUIClass());
        Class<? extends UI> uiClass = applicationFactory.getUIClass();
        this.factories.put(uiClass.getCanonicalName(), applicationFactory);
    }

    public synchronized void removeApplicationFactory(ApplicationFactory applicationFactory) {
        Objects.requireNonNull(applicationFactory);
        Objects.requireNonNull(applicationFactory.getUIClass());
        this.factories.remove(applicationFactory.getUIClass().getCanonicalName());
    }

    private String extractUIClassName(UIProviderEvent event) {
        return event.getService().getDeploymentConfiguration().getInitParameters().getProperty("ui.class");
    }
}

