/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Table;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.security.core.context.SecurityContextHolder;

public class CheckboxGenerator
implements Table.ColumnGenerator,
Container.ItemSetChangeListener {
    private static final long serialVersionUID = 2L;
    private final String m_valueProperty;
    protected final Set<CheckBox> m_checkboxes = new HashSet<CheckBox>();
    protected Set<Integer> m_selectedCheckboxes = new TreeSet<Integer>();
    protected Set<Integer> m_notSelectedCheckboxes = new TreeSet<Integer>();
    private boolean m_selectAll = false;

    public CheckboxGenerator(String valueProperty) {
        this.m_valueProperty = valueProperty;
    }

    public Object generateCell(Table source, Object itemId, Object columnId) {
        final Property property = source.getContainerProperty(itemId, (Object)this.m_valueProperty);
        if (property.getValue() == null) {
            return null;
        }
        if (SecurityContextHolder.getContext().toString().contains("ROLE_READONLY")) {
            return null;
        }
        CheckBox button = new CheckBox();
        button.setData(property.getValue());
        button.setValue((Object)this.isSelected((Integer)property.getValue()));
        button.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 2991986878904005830L;

            public void valueChange(Property.ValueChangeEvent event) {
                if (Boolean.TRUE.equals(event.getProperty().getValue())) {
                    CheckboxGenerator.this.m_selectedCheckboxes.add((Integer)property.getValue());
                    CheckboxGenerator.this.m_notSelectedCheckboxes.remove(property.getValue());
                } else {
                    CheckboxGenerator.this.m_selectedCheckboxes.remove(property.getValue());
                    CheckboxGenerator.this.m_notSelectedCheckboxes.add((Integer)property.getValue());
                }
            }
        });
        this.m_checkboxes.add(button);
        return button;
    }

    private boolean isSelected(Integer id) {
        return (this.m_selectAll || this.m_selectedCheckboxes.contains(id)) && !this.m_notSelectedCheckboxes.contains(id);
    }

    public Set<Integer> getSelectedIds(Table source) {
        if (this.m_selectAll) {
            TreeSet<Integer> selected = new TreeSet<Integer>();
            for (Object eachItemId : source.getItemIds()) {
                Property property = source.getContainerProperty(eachItemId, (Object)this.m_valueProperty);
                if (property == null) continue;
                selected.add((Integer)property.getValue());
            }
            selected.removeAll(this.m_notSelectedCheckboxes);
            return selected;
        }
        return Collections.unmodifiableSet(this.m_selectedCheckboxes);
    }

    public void clearSelectedIds(Table source) {
        this.m_selectAll = false;
        for (CheckBox button : this.m_checkboxes) {
            button.setValue((Object)false);
        }
        this.m_selectedCheckboxes.clear();
        this.m_notSelectedCheckboxes.clear();
    }

    public void selectAll(Table source) {
        this.m_selectAll = true;
        this.m_selectedCheckboxes.clear();
        this.m_notSelectedCheckboxes.clear();
        for (CheckBox button : this.m_checkboxes) {
            button.setValue((Object)true);
            this.m_selectedCheckboxes.add((Integer)button.getData());
        }
    }

    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        this.m_checkboxes.clear();
        Iterator<Integer> itr = this.m_selectedCheckboxes.iterator();
        while (itr.hasNext()) {
            if (event.getContainer().getItemIds().contains(itr.next())) continue;
            itr.remove();
        }
        itr = this.m_notSelectedCheckboxes.iterator();
        while (itr.hasNext()) {
            if (event.getContainer().getItemIds().contains(itr.next())) continue;
            itr.remove();
        }
    }
}

