/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction.synchronization;

import javax.transaction.SystemException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.synchronization.AfterCompletionAction;
import org.hibernate.transaction.synchronization.BeforeCompletionManagedFlushChecker;
import org.hibernate.transaction.synchronization.ExceptionMapper;
import org.hibernate.util.JTAHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackCoordinator {
    private static final Logger log = LoggerFactory.getLogger(CallbackCoordinator.class);
    private final TransactionFactory.Context ctx;
    private JDBCContext jdbcContext;
    private final javax.transaction.Transaction jtaTransaction;
    private final Transaction hibernateTransaction;
    private BeforeCompletionManagedFlushChecker beforeCompletionManagedFlushChecker;
    private AfterCompletionAction afterCompletionAction;
    private ExceptionMapper exceptionMapper;
    private static final BeforeCompletionManagedFlushChecker STANDARD_MANAGED_FLUSH_CHECKER = new BeforeCompletionManagedFlushChecker(){

        public boolean shouldDoManagedFlush(TransactionFactory.Context ctx, javax.transaction.Transaction jtaTransaction) throws SystemException {
            return !ctx.isFlushModeNever() && ctx.isFlushBeforeCompletionEnabled() && !JTAHelper.isRollback(jtaTransaction.getStatus());
        }
    };
    private static final ExceptionMapper STANDARD_EXCEPTION_MAPPER = new ExceptionMapper(){

        public RuntimeException mapStatusCheckFailure(String message, SystemException systemException) {
            log.error("could not determine transaction status [{}]", (Object)systemException.getMessage());
            return new TransactionException("could not determine transaction status in beforeCompletion()", systemException);
        }

        public RuntimeException mapManagedFlushFailure(String message, RuntimeException failure) {
            log.error("Error during managed flush [{}]", (Object)failure.getMessage());
            return failure;
        }
    };
    private static final AfterCompletionAction STANDARD_AFTER_COMPLETION_ACTION = new AfterCompletionAction(){

        public void doAction(TransactionFactory.Context ctx, int status) {
        }
    };

    public CallbackCoordinator(TransactionFactory.Context ctx, JDBCContext jdbcContext, javax.transaction.Transaction jtaTransaction, Transaction hibernateTransaction) {
        this.ctx = ctx;
        this.jdbcContext = jdbcContext;
        this.jtaTransaction = jtaTransaction;
        this.hibernateTransaction = hibernateTransaction;
        this.reset();
    }

    public void reset() {
        this.beforeCompletionManagedFlushChecker = STANDARD_MANAGED_FLUSH_CHECKER;
        this.exceptionMapper = STANDARD_EXCEPTION_MAPPER;
        this.afterCompletionAction = STANDARD_AFTER_COMPLETION_ACTION;
    }

    public BeforeCompletionManagedFlushChecker getBeforeCompletionManagedFlushChecker() {
        return this.beforeCompletionManagedFlushChecker;
    }

    public void setBeforeCompletionManagedFlushChecker(BeforeCompletionManagedFlushChecker beforeCompletionManagedFlushChecker) {
        this.beforeCompletionManagedFlushChecker = beforeCompletionManagedFlushChecker;
    }

    public ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    public AfterCompletionAction getAfterCompletionAction() {
        return this.afterCompletionAction;
    }

    public void setAfterCompletionAction(AfterCompletionAction afterCompletionAction) {
        this.afterCompletionAction = afterCompletionAction;
    }

    public void beforeCompletion() {
        boolean flush;
        log.trace("transaction before completion callback");
        try {
            flush = this.beforeCompletionManagedFlushChecker.shouldDoManagedFlush(this.ctx, this.jtaTransaction);
        }
        catch (SystemException se) {
            this.setRollbackOnly();
            throw this.exceptionMapper.mapStatusCheckFailure("could not determine transaction status in beforeCompletion()", se);
        }
        try {
            if (flush) {
                log.trace("automatically flushing session");
                this.ctx.managedFlush();
            }
        }
        catch (RuntimeException re) {
            this.setRollbackOnly();
            throw this.exceptionMapper.mapManagedFlushFailure("error during managed flush", re);
        }
        finally {
            this.jdbcContext.beforeTransactionCompletion(this.hibernateTransaction);
        }
    }

    private void setRollbackOnly() {
        try {
            this.jtaTransaction.setRollbackOnly();
        }
        catch (SystemException se) {
            log.error("could not set transaction to rollback only", (Throwable)se);
        }
    }

    public void afterCompletion(int status) {
        log.trace("transaction after completion callback [status={}]", (Object)status);
        try {
            this.afterCompletionAction.doAction(this.ctx, status);
            boolean wasSuccessful = status == 3;
            this.jdbcContext.afterTransactionCompletion(wasSuccessful, this.hibernateTransaction);
        }
        finally {
            this.reset();
            this.jdbcContext.cleanUpJtaSynchronizationCallbackCoordinator();
            if (this.ctx.shouldAutoClose() && !this.ctx.isClosed()) {
                log.trace("automatically closing session");
                this.ctx.managedClose();
            }
        }
    }
}

