/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.ContextExpression;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Labels;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.exception.DatabaseException;
import liquibase.parser.ChangeLogParserCofiguration;
import liquibase.util.StringUtils;

public class ChangeLogParameters {
    private List<ChangeLogParameter> changeLogParameters = new ArrayList<ChangeLogParameter>();
    private ExpressionExpander expressionExpander;
    private Database currentDatabase;
    private Contexts currentContexts;
    private LabelExpression currentLabelExpression;

    public ChangeLogParameters() {
        this(null);
    }

    public ChangeLogParameters(Database database) {
        for (Map.Entry<Object, Object> entry : ((Properties)System.getProperties().clone()).entrySet()) {
            this.changeLogParameters.add(new ChangeLogParameter(entry.getKey().toString(), entry.getValue()));
        }
        if (database != null) {
            this.set("database.autoIncrementClause", database.getAutoIncrementClause(null, null));
            this.set("database.currentDateTimeFunction", database.getCurrentDateTimeFunction());
            this.set("database.databaseChangeLogLockTableName", database.getDatabaseChangeLogLockTableName());
            this.set("database.databaseChangeLogTableName", database.getDatabaseChangeLogTableName());
            try {
                this.set("database.databaseMajorVersion", database.getDatabaseMajorVersion());
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            try {
                this.set("database.databaseMinorVersion", database.getDatabaseMinorVersion());
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            this.set("database.databaseProductName", database.getDatabaseProductName());
            try {
                this.set("database.databaseProductVersion", database.getDatabaseProductVersion());
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            this.set("database.defaultCatalogName", database.getDefaultCatalogName());
            this.set("database.defaultSchemaName", database.getDefaultSchemaName());
            this.set("database.defaultSchemaNamePrefix", StringUtils.trimToNull(database.getDefaultSchemaName()) == null ? "" : "." + database.getDefaultSchemaName());
            this.set("database.lineComment", database.getLineComment());
            this.set("database.liquibaseSchemaName", database.getLiquibaseSchemaName());
            this.set("database.typeName", database.getShortName());
            try {
                this.set("database.isSafeToRunUpdate", database.isSafeToRunUpdate());
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            this.set("database.requiresPassword", database.requiresPassword());
            this.set("database.requiresUsername", database.requiresUsername());
            this.set("database.supportsForeignKeyDisable", database.supportsForeignKeyDisable());
            this.set("database.supportsInitiallyDeferrableColumns", database.supportsInitiallyDeferrableColumns());
            this.set("database.supportsRestrictForeignKeys", database.supportsRestrictForeignKeys());
            this.set("database.supportsSchemas", database.supportsSchemas());
            this.set("database.supportsSequences", database.supportsSequences());
            this.set("database.supportsTablespaces", database.supportsTablespaces());
            this.set("database.supportsNotNullConstraintNames", database.supportsNotNullConstraintNames());
        }
        this.expressionExpander = new ExpressionExpander(this);
        this.currentDatabase = database;
        this.currentContexts = new Contexts();
        this.currentLabelExpression = new LabelExpression();
    }

    public void setContexts(Contexts contexts) {
        this.currentContexts = contexts;
    }

    public Contexts getContexts() {
        return this.currentContexts;
    }

    public List<ChangeLogParameter> getChangeLogParameters() {
        return Collections.unmodifiableList(this.changeLogParameters);
    }

    public void set(String paramter, Object value) {
        ChangeLogParameter param = this.findParameter(paramter, null);
        if (param == null) {
            this.changeLogParameters.add(new ChangeLogParameter(paramter, value));
        }
    }

    public void set(String key, String value, String contexts, String labels, String databases, boolean globalParam, DatabaseChangeLog changeLog) {
        this.set(key, value, new ContextExpression(contexts), new Labels(labels), databases, globalParam, changeLog);
    }

    public void set(String key, String value, ContextExpression contexts, Labels labels, String databases, boolean globalParam, DatabaseChangeLog changeLog) {
        if (globalParam) {
            ChangeLogParameter param = this.findParameter(key, null);
            if (param == null) {
                this.changeLogParameters.add(new ChangeLogParameter(key, value, contexts, labels, databases, globalParam, changeLog));
            }
        } else {
            this.changeLogParameters.add(new ChangeLogParameter(key, value, contexts, labels, databases, globalParam, changeLog));
        }
    }

    public Object getValue(String key, DatabaseChangeLog changeLog) {
        ChangeLogParameter parameter = this.findParameter(key, changeLog);
        return parameter != null ? parameter.getValue() : null;
    }

    private ChangeLogParameter findParameter(String key, DatabaseChangeLog changeLog) {
        ChangeLogParameter result = null;
        ArrayList<ChangeLogParameter> found = new ArrayList<ChangeLogParameter>();
        for (ChangeLogParameter param : this.changeLogParameters) {
            if (!param.getKey().equalsIgnoreCase(key) || !param.isValid()) continue;
            found.add(param);
        }
        if (found.size() == 1) {
            result = (ChangeLogParameter)found.get(0);
        } else if (found.size() > 1) {
            for (ChangeLogParameter changeLogParameter : found) {
                if (!changeLogParameter.getChangeLog().equals(changeLog)) continue;
                result = changeLogParameter;
            }
        }
        return result;
    }

    public boolean hasValue(String key, DatabaseChangeLog changeLog) {
        return this.findParameter(key, changeLog) != null;
    }

    public String expandExpressions(String string, DatabaseChangeLog changeLog) {
        return this.expressionExpander.expandExpressions(string, changeLog);
    }

    public void setLabels(LabelExpression labels) {
        this.currentLabelExpression = labels;
    }

    public LabelExpression getLabels() {
        return this.currentLabelExpression;
    }

    public class ChangeLogParameter {
        private String key;
        private Object value;
        private ContextExpression validContexts;
        private Labels labels;
        private List<String> validDatabases;
        private boolean global = true;
        private DatabaseChangeLog changeLog;

        public ChangeLogParameter(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public ChangeLogParameter(String key, Object value, String validContexts, String labels, String validDatabases, boolean globalParam, DatabaseChangeLog changeLog) {
            this(key, value, new ContextExpression(validContexts), new Labels(labels), StringUtils.splitAndTrim(validDatabases, ","), globalParam, changeLog);
        }

        private ChangeLogParameter(String key, Object value, ContextExpression validContexts, Labels labels, String validDatabases, boolean globalParam, DatabaseChangeLog changeLog) {
            this(key, value, validContexts, labels, StringUtils.splitAndTrim(validDatabases, ","), globalParam, changeLog);
        }

        public ChangeLogParameter(String key, Object value, ContextExpression validContexts, Labels labels, List<String> validDatabases, boolean globalParam, DatabaseChangeLog changeLog) {
            this.key = key;
            this.value = value;
            this.validContexts = validContexts;
            this.labels = labels;
            this.validDatabases = validDatabases;
            this.global = globalParam;
            this.changeLog = changeLog;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public List<String> getValidDatabases() {
            return this.validDatabases;
        }

        public ContextExpression getValidContexts() {
            return this.validContexts;
        }

        public Labels getLabels() {
            return this.labels;
        }

        public String toString() {
            return this.getValue().toString();
        }

        public boolean isValid() {
            boolean isValid;
            boolean bl = isValid = this.validContexts == null || this.validContexts.matches(ChangeLogParameters.this.currentContexts);
            if (isValid) {
                boolean bl2 = isValid = this.labels == null || ChangeLogParameters.this.currentLabelExpression == null || ChangeLogParameters.this.currentLabelExpression.matches(this.labels);
            }
            if (isValid) {
                isValid = DatabaseList.definitionMatches(this.validDatabases, ChangeLogParameters.this.currentDatabase, true);
            }
            return isValid;
        }

        public boolean isGlobal() {
            return this.global;
        }

        public DatabaseChangeLog getChangeLog() {
            return this.changeLog;
        }
    }

    protected static class ExpressionExpander {
        private boolean enableEscaping;
        private ChangeLogParameters changeLogParameters;
        private static final Pattern EXPRESSION_PATTERN = Pattern.compile("(\\$\\{[^\\}]+\\})");

        public ExpressionExpander(ChangeLogParameters changeLogParameters) {
            this.changeLogParameters = changeLogParameters;
            this.enableEscaping = LiquibaseConfiguration.getInstance().getConfiguration(ChangeLogParserCofiguration.class).getSupportPropertyEscaping();
        }

        public String expandExpressions(String text, DatabaseChangeLog changeLog) {
            if (text == null) {
                return null;
            }
            Matcher matcher = EXPRESSION_PATTERN.matcher(text);
            String originalText = text;
            while (matcher.find()) {
                String expressionString = originalText.substring(matcher.start(), matcher.end());
                String valueTolookup = expressionString.replaceFirst("\\$\\{", "").replaceFirst("\\}$", "");
                Object value = this.enableEscaping && valueTolookup.startsWith(":") ? null : this.changeLogParameters.getValue(valueTolookup, changeLog);
                if (value == null) continue;
                text = text.replace(expressionString, value.toString());
            }
            if (this.enableEscaping) {
                text = text.replaceAll("\\$\\{:(.+?)}", "\\$\\{$1}");
            }
            return text;
        }
    }
}

