/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.samplewrite;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.opennms.core.cache.Cache;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.netmgt.collection.api.AbstractPersister;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.PersistException;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.timeseries.samplewrite.MetaTagDataLoader;
import org.opennms.netmgt.timeseries.samplewrite.TimeseriesPersistOperationBuilder;
import org.opennms.netmgt.timeseries.samplewrite.TimeseriesWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesPersister
extends AbstractPersister {
    private static final Logger LOG = LoggerFactory.getLogger(TimeseriesPersister.class);
    private final RrdRepository repository;
    private final TimeseriesWriter writer;
    private final MetaTagDataLoader metaDataLoader;
    private final Cache<ResourcePath, Set<Tag>> configuredAdditionalMetaTagCache;
    private TimeseriesPersistOperationBuilder currentBuilder;
    private List<TimeseriesPersistOperationBuilder> allBuilders;
    private Map<ResourcePath, Map<String, String>> resourceLevelStringAttributes;
    private final MetricRegistry metricRegistry;

    protected TimeseriesPersister(ServiceParameters params, RrdRepository repository, TimeseriesWriter timeseriesWriter, MetaTagDataLoader metaDataLoader, Cache<ResourcePath, Set<Tag>> configuredAdditionalMetaTagCache, MetricRegistry metricRegistry) {
        super(params, repository);
        this.repository = repository;
        this.writer = timeseriesWriter;
        this.metaDataLoader = metaDataLoader;
        this.configuredAdditionalMetaTagCache = configuredAdditionalMetaTagCache;
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "metricRegistry can not be null");
    }

    public void visitResource(CollectionResource resource) {
        super.visitResource(resource);
        this.configuredAdditionalMetaTagCache.put((Object)resource.getPath(), this.metaDataLoader.load(resource));
        this.resourceLevelStringAttributes = Maps.newLinkedHashMap();
        this.allBuilders = new ArrayList<TimeseriesPersistOperationBuilder>();
    }

    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
        if (this.shouldPersist()) {
            CollectionResource resource = group.getResource();
            Set<Tag> metaTags = this.getUserDefinedMetaTags(resource);
            this.currentBuilder = new TimeseriesPersistOperationBuilder(this.writer, this.repository, (ResourceIdentifier)resource, group.getName(), metaTags, this.resourceLevelStringAttributes, this.metricRegistry);
            if (resource.getTimeKeeper() != null) {
                this.currentBuilder.setTimeKeeper(resource.getTimeKeeper());
            }
            this.setBuilder(this.currentBuilder);
            this.allBuilders.add(this.currentBuilder);
        }
    }

    private Set<Tag> getUserDefinedMetaTags(CollectionResource resource) {
        try {
            return (Set)this.configuredAdditionalMetaTagCache.get((Object)resource.getPath());
        }
        catch (ExecutionException e) {
            LOG.warn("An exception occurred while trying to retrieve meta tags for {}", (Object)resource.getPath(), (Object)e);
            return Collections.emptySet();
        }
    }

    protected void persistStringAttribute(ResourcePath path, String key, String value) throws PersistException {
        this.currentBuilder.persistStringAttribute(path, key, value);
    }

    public void completeResource(CollectionResource resource) {
        if (this.shouldPersist()) {
            this.allBuilders.forEach(this::commitBuilder);
        }
        this.popShouldPersist();
    }

    public void commitBuilder(TimeseriesPersistOperationBuilder builder) {
        if (this.isPersistDisabled()) {
            LOG.debug("Persist disabled for {}", (Object)builder.getName());
            return;
        }
        try {
            builder.commit();
        }
        catch (PersistException e) {
            LOG.error("Unable to persist data for {}", (Object)builder.getName(), (Object)e);
        }
    }

    public void persistNumericAttribute(CollectionAttribute attribute) {
        boolean shouldIgnorePersist = this.isIgnorePersist() && AttributeType.COUNTER.equals((Object)attribute.getType());
        LOG.trace("Persisting {} {}", (Object)attribute, (Object)(shouldIgnorePersist ? ". Ignoring value because of sysUpTime changed." : ""));
        Number value = shouldIgnorePersist ? (Number)Double.NaN : (Number)attribute.getNumericValue();
        this.currentBuilder.setAttributeValue(attribute.getAttributeType(), value);
        if (attribute.getMetricIdentifier() != null) {
            ResourcePath path = ResourceTypeUtils.getResourcePathWithRepository((RrdRepository)this.repository, (ResourcePath)ResourcePath.get((ResourcePath)attribute.getResource().getPath(), (String[])new String[]{attribute.getAttributeType().getGroupType().getName()}));
            this.currentBuilder.persistStringAttributeForMetricLevel(path, attribute.getName(), attribute.getMetricIdentifier(), attribute.getName());
        }
    }
}

