/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.samplewrite;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.core.mate.api.FallbackScope;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTag;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.LatencyCollectionResource;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.timeseries.samplewrite.MetaTagConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaTagDataLoader
extends CacheLoader<CollectionResource, Set<Tag>> {
    private static final Logger LOG = LoggerFactory.getLogger(MetaTagDataLoader.class);
    private final NodeDao nodeDao;
    private final SessionUtils sessionUtils;
    private final EntityScopeProvider entityScopeProvider;
    private MetaTagConfiguration config;

    @Inject
    public MetaTagDataLoader(NodeDao nodeDao, SessionUtils sessionUtils, EntityScopeProvider entityScopeProvider) {
        this.nodeDao = Objects.requireNonNull(nodeDao, "nodeDao must not be null");
        this.sessionUtils = Objects.requireNonNull(sessionUtils, "sessionUtils must not be null");
        this.entityScopeProvider = Objects.requireNonNull(entityScopeProvider, "entityScopeProvider must not be null");
        this.setConfig(new MetaTagConfiguration((Map<String, String>)Maps.fromProperties((Properties)System.getProperties())));
    }

    public void setConfig(MetaTagConfiguration config) {
        this.config = config;
    }

    public Set<Tag> load(CollectionResource resource) {
        return (Set)this.sessionUtils.withReadOnlyTransaction(() -> {
            HashSet<Tag> tags = new HashSet<Tag>();
            ArrayList<Scope> scopes = new ArrayList<Scope>();
            String nodeCriteria = this.getNodeCriteriaFromResource(resource);
            Optional<OnmsNode> nodeOptional = this.getNode(nodeCriteria);
            if (nodeOptional.isPresent()) {
                OnmsNode node = nodeOptional.get();
                scopes.add(this.entityScopeProvider.getScopeForNode(node.getId()));
                if (resource.getResourceTypeName().equals("if")) {
                    try {
                        int ifIndex = Integer.parseInt(resource.getInstance());
                        scopes.add(this.entityScopeProvider.getScopeForInterfaceByIfIndex(node.getId(), ifIndex));
                    }
                    catch (NumberFormatException ifIndex) {
                        // empty catch block
                    }
                }
                try {
                    if (resource.getResourceTypeName().equals("latency") && resource.getServiceParams().containsKey("interface-info-in-tags") && Boolean.parseBoolean((String)resource.getServiceParams().get("interface-info-in-tags"))) {
                        if (resource instanceof LatencyCollectionResource) {
                            String ipAddress = ((LatencyCollectionResource)resource).getIpAddress();
                            scopes.add(this.entityScopeProvider.getScopeForInterface(node.getId(), ipAddress));
                            scopes.add(this.entityScopeProvider.getScopeForService(node.getId(), InetAddressUtils.addr((String)ipAddress), ((LatencyCollectionResource)resource).getServiceName()));
                        } else {
                            String[] ipAddressAndService = MetaTagDataLoader.parseInstance(resource.getInstance());
                            String ipAddress = ipAddressAndService[0];
                            String serviceName = ipAddressAndService[1];
                            scopes.add(this.entityScopeProvider.getScopeForInterface(node.getId(), ipAddress));
                            scopes.add(this.entityScopeProvider.getScopeForService(node.getId(), InetAddressUtils.addr((String)ipAddress), serviceName));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to add scope for resource {}", (Object)resource, (Object)e);
                }
            }
            FallbackScope scope = new FallbackScope(scopes);
            Map<String, String> configuredMetaTags = this.config.getConfiguredMetaTags();
            for (Map.Entry<String, String> entry : configuredMetaTags.entrySet()) {
                String value = Interpolator.interpolate((String)entry.getValue(), (Scope)scope).output;
                if (Strings.isNullOrEmpty((String)value)) continue;
                tags.add((Tag)new ImmutableTag(entry.getKey(), value));
            }
            nodeOptional.ifPresent(onmsNode -> this.mapCategories((Set<Tag>)tags, (OnmsNode)onmsNode));
            this.mapResourceTags(configuredMetaTags, tags, resource);
            return tags;
        });
    }

    private void mapCategories(Set<Tag> tags, OnmsNode node) {
        Objects.requireNonNull(node);
        if (this.config.isCategoriesEnabled()) {
            ArrayList catList = new ArrayList();
            node.getCategories().stream().map(OnmsCategory::getName).forEach(catName -> {
                tags.add((Tag)new ImmutableTag("cat_" + catName, catName));
                catList.add(catName);
            });
            if (!catList.isEmpty()) {
                Collections.sort(catList);
                String categories = String.join((CharSequence)",", catList);
                tags.add((Tag)new ImmutableTag("categories", categories));
            }
        }
    }

    private void mapResourceTags(Map<String, String> configuredMetaTags, Set<Tag> tags, CollectionResource resource) {
        for (Map.Entry<String, String> entry : configuredMetaTags.entrySet()) {
            if (entry.getValue().contains("resource:label") && resource.getInterfaceLabel() != null) {
                tags.add((Tag)new ImmutableTag(entry.getKey(), resource.getInterfaceLabel()));
            }
            if (entry.getValue().contains("resource:node_label") && resource.getTags().get("node_label") != null) {
                tags.add((Tag)new ImmutableTag(entry.getKey(), (String)resource.getTags().get("node_label")));
            }
            if (entry.getValue().contains("resource:location") && resource.getTags().get("location") != null) {
                tags.add((Tag)new ImmutableTag(entry.getKey(), (String)resource.getTags().get("location")));
            }
            if (!entry.getValue().contains("resource:node_id") || resource.getTags().get("node_id") == null) continue;
            tags.add((Tag)new ImmutableTag(entry.getKey(), (String)resource.getTags().get("node_id")));
        }
    }

    private Optional<OnmsNode> getNode(String nodeCriteria) {
        if (nodeCriteria == null || nodeCriteria.trim().isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(this.nodeDao.get(nodeCriteria));
        }
        catch (Exception e) {
            LOG.error("Error while trying to load node for criteria: {}. No node will be returned.", (Object)nodeCriteria, (Object)e);
            return Optional.empty();
        }
    }

    private String getNodeCriteriaFromResource(CollectionResource resource) {
        String[] resourcePathArray;
        Object nodeCriteria = null;
        if (resource.getParent() != null && (resourcePathArray = resource.getParent().elements()) != null && resourcePathArray.length > 0) {
            if ("fs".equals(resourcePathArray[0]) && resourcePathArray.length == 3) {
                nodeCriteria = resourcePathArray[1] + ":" + resourcePathArray[2];
            } else if (this.checkNumeric(resourcePathArray[0])) {
                nodeCriteria = resourcePathArray[0];
            }
        }
        if (nodeCriteria == null && !resource.getTags().isEmpty()) {
            return resource.getTags().getOrDefault("node_id", null);
        }
        return nodeCriteria;
    }

    private String getIpAddressFromInstance(String instance) {
        if (instance != null && instance.contains("[")) {
            return instance.substring(0, instance.indexOf("["));
        }
        throw new IllegalArgumentException("not able to parse ipAddress from instance");
    }

    private static String[] parseInstance(String instance) {
        if (instance == null || !instance.contains("[") || !instance.endsWith("]")) {
            throw new IllegalArgumentException("Invalid instance format");
        }
        String ipAddress = instance.substring(0, instance.indexOf("["));
        String serviceName = instance.substring(instance.indexOf("[") + 1, instance.length() - 1);
        return new String[]{ipAddress, serviceName};
    }

    private boolean checkNumeric(String nodeCriteria) {
        try {
            Integer.parseInt(nodeCriteria);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

