/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceConfigFactory
implements org.opennms.netmgt.config.api.ServiceConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceConfigFactory.class);
    private ServiceConfiguration m_config;

    public ServiceConfigFactory() {
        this.reload();
    }

    public synchronized void reload() {
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SERVICE_CONF_FILE_NAME);
            LOG.debug("ServiceConfigFactory.init: config file path {}", (Object)cfgFile.getPath());
            ServiceConfiguration userConfig = (ServiceConfiguration)JaxbUtils.unmarshal(ServiceConfiguration.class, (File)cfgFile);
            this.m_config = ServiceConfiguration.mergeWithDefaults((ServiceConfiguration)userConfig);
            LOG.info("Merged user service configuration with defaults");
        }
        catch (IOException e) {
            LOG.error("Could not open configuration file: " + ConfigFileConstants.SERVICE_CONF_FILE_NAME, (Throwable)e);
        }
    }

    public Service[] getServices() {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Service s : this.m_config.getServices()) {
            if (!s.isEnabled().booleanValue()) continue;
            services.add(s);
        }
        return services.toArray(new Service[services.size()]);
    }

    public Map<String, Boolean> getServiceNameMap() {
        return this.m_config.getServices().stream().collect(Collectors.toMap(s -> s.getName().replace("OpenNMS:Name=", ""), s -> s.isEnabled()));
    }
}

